import { SLIDER_CATEGORIES } from "@/app/_constants/componentConstant";
import { pxToRem } from "@/app/_utils";
const {
  WHATS_NEW_SLIDER,
  USERS_STORY_SLIDER,
  EVENT_SLIDER,
  PHOTO_GALLERY_SLIDER,
  PHOTO_VIDEO_GALLERY,
  VIDEO_GALLERY_SLIDER,
  ACTIVITY_SLIDER,
  RELATED_ACTIVITY_SLIDER,
  ACCOMODATION_SLIDER,
  TOUR_GUIDE_SLIDER,
  DESTINATION_SLIDER,
  CUSTOMER_REVIEW_SLIDER,
  INFORMATION_SLIDER,
  EBROUCHURE_SLIDER,
  EBROCHURES_SLIDER,
  PORTFOLIO_SLIDER,
  STORY_SLIDER,
  TOUR_PACKAGE_SLIDER,
} = SLIDER_CATEGORIES;

// Carousal Section Props
export const carouselSectionProps = (scrollKey) => ({
  id: scrollKey,
});

// Carousal Container Props
export const containerProps = (category) => ({
  pos: "relative",
  ...(category !== USERS_STORY_SLIDER && category != EBROCHURES_SLIDER
    ? {
        maxW: "container.2xl",
      }
    : { maxW: "full", px: 0 }),
});

// Carousal Container Props
export const sliderContainerProps = (category) => ({
  ...([
    ACTIVITY_SLIDER,
    RELATED_ACTIVITY_SLIDER,
    ACCOMODATION_SLIDER,
    INFORMATION_SLIDER,
    CUSTOMER_REVIEW_SLIDER,
    EBROUCHURE_SLIDER,
    STORY_SLIDER,
    TOUR_PACKAGE_SLIDER,
  ].some((s) => s === category) && {
    ml: "-1%",
  }),
  ...(category === ACTIVITY_SLIDER && {
    h: {
      base: 450,
      md: 520,
      lg: 556,
    },
  }),
  ...(new Set([
    RELATED_ACTIVITY_SLIDER,
    INFORMATION_SLIDER,
    CUSTOMER_REVIEW_SLIDER,
    EBROUCHURE_SLIDER,
    PORTFOLIO_SLIDER,
    STORY_SLIDER,
    TOUR_PACKAGE_SLIDER,
  ]).has(category) && {
    h: "auto",
  }),
});

// Carousal Props
export const carousalProps = (category, link = false, isMobile) => ({
  showArrows: true,
  arrowBottomPadding: link,
  // ...([
  //   WHATS_NEW_SLIDER,
  //   USERS_STORY_SLIDER,
  //   EVENT_SLIDER,
  //   TOUR_GUIDE_SLIDER,
  // ].some((s) => s === category) && {
  //   showDots: true,
  // }),
  ...([
    ACTIVITY_SLIDER,
    RELATED_ACTIVITY_SLIDER,
    DESTINATION_SLIDER,
    EVENT_SLIDER,
    USERS_STORY_SLIDER,
    EBROCHURES_SLIDER,    
    TOUR_GUIDE_SLIDER,
    ACCOMODATION_SLIDER,
    INFORMATION_SLIDER,
    CUSTOMER_REVIEW_SLIDER,
    EBROUCHURE_SLIDER,
    STORY_SLIDER,
    TOUR_PACKAGE_SLIDER,
  ].some((s) => s === category) && {
    arrowColor: "black",
  }),
  ...([WHATS_NEW_SLIDER, PHOTO_GALLERY_SLIDER, VIDEO_GALLERY_SLIDER, PHOTO_VIDEO_GALLERY].some(
    (s) => s === category && isMobile
  ) && {
    arrowColor: "black",
  }),
  ...([
    ACTIVITY_SLIDER,
    RELATED_ACTIVITY_SLIDER,
    DESTINATION_SLIDER,
    EVENT_SLIDER,
    TOUR_GUIDE_SLIDER,
    ACCOMODATION_SLIDER,
    INFORMATION_SLIDER,
    CUSTOMER_REVIEW_SLIDER,
    EBROUCHURE_SLIDER,
    STORY_SLIDER,
    TOUR_PACKAGE_SLIDER,
  ].some((s) => s === category) && {
    arrowPosition: "center",
    slideToScroll: 4,
  }),
  ...([
    PHOTO_GALLERY_SLIDER,
    PHOTO_VIDEO_GALLERY,
    VIDEO_GALLERY_SLIDER,
    WHATS_NEW_SLIDER,
    INFORMATION_SLIDER,
    PORTFOLIO_SLIDER,
    TOUR_PACKAGE_SLIDER,
  ].some((s) => s === category && link) && {
    hasBottomLink: true,
  }),
  ...([ACTIVITY_SLIDER, INFORMATION_SLIDER, CUSTOMER_REVIEW_SLIDER].some(
    (s) => s === category
  ) && {
    overflow: true,
  }),
  ...(category === PORTFOLIO_SLIDER && {
    arrowPosition: "center",
    arrowColor: "black",
    slideToScroll: 5,
  }),
});

// Slider Item wrapper Props
export const sliderItemProps = (category) => ({
  pos: "relative",
  minW: 0,
  ...([
    ACTIVITY_SLIDER,
    RELATED_ACTIVITY_SLIDER,
    DESTINATION_SLIDER,
    EVENT_SLIDER,
    TOUR_GUIDE_SLIDER,
    ACCOMODATION_SLIDER,
    INFORMATION_SLIDER,
    CUSTOMER_REVIEW_SLIDER,
    EBROUCHURE_SLIDER,
    STORY_SLIDER,
    TOUR_PACKAGE_SLIDER,
  ].some((s) => s === category) && {
    flex: {
      base: "0 0 98%",
      md: "0 0 48%",
      lg: "0 0 31.33%",
      "2xl": "0 0 23%",
    },
    mr: "1%",
    ml: "1%",
  }),
  ...([PHOTO_GALLERY_SLIDER, PHOTO_VIDEO_GALLERY, WHATS_NEW_SLIDER, VIDEO_GALLERY_SLIDER].some((s) => s === category) && {
    flex: "0 0 99%",
    mr: "0.5%",
    ml: "0.5%",
  }),
  ...((category === USERS_STORY_SLIDER || category === EBROCHURES_SLIDER) &&{
    flex: "0 0 100%",
  }),
  ...(category === PORTFOLIO_SLIDER && {
    flex: {
      base: "0 0 98%",
      sm: "0 0 48%",
      md: "0 0 31.33%",
      lg: "0 0 23%",
      "2xl": "0 0 18%",
    },
    mr: "1%",
    ml: "1%",
  }),
});

export const learnMoreBtnStyle = {
  pos: {
    base: "relative",
    lg: "absolute",
  },
  right: {
    base: 0,
    lg: "30px",
  },
  bottom: 0,
  left: {
    base: 0,
    lg: "auto",
  },
  textAlign: {
    base: "center",
    lg: "right",
  },
};

export const usersStoryLearnMoreBtnStyle = {
  pos: "absolute",
  right: {
    base: 0,
    lg: "40px",
  },
  left: {
    base: 0,
    lg: "auto",
  },
  margin: {
    base: "auto",
  },
  textAlign: {
    base: "center",
  },
  bottom: { base: 0 },
};
