import { useCallback, useEffect, useState } from "react";
import { useMediaQuery } from "@chakra-ui/react";

export default function useNoOfSlider() {
  const [noOfSlider, setNumberSlider] = useState(0);

  const [isSmall, isMedium, isLarge, isXLarge] = useMediaQuery(
    [
      "(max-width: 480px)",
      "(min-width: 481px) and (max-width: 767px)",
      "(min-width: 768px) and (max-width: 992px)",
      "(min-width: 992px)",
    ],
    { ssr: true, fallback: false }
  );

  const handleUpdateSlider = useCallback(() => {
    if (isSmall) setNumberSlider(1);
    else if (isMedium) setNumberSlider(2);
    else if (isLarge) setNumberSlider(3);
    else if (isXLarge) setNumberSlider(4);
  }, [isSmall, isMedium, isLarge, isXLarge]);

  useEffect(() => {
    handleUpdateSlider();
  }, [isSmall, isMedium, isLarge, isXLarge]);

  return [noOfSlider];
}
