import { Box, Text, useMediaQuery } from "@chakra-ui/react";
import { KtHeading, AppBox, AppLink, AppImage } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import {
  descriptionWrapperStyle,
  descriptionInnerWrapperStyle,
} from "./_styles";
import Link from "next/link";
const WhatsNew = ({
  heading,
  description,
  image: { url, alt, base64 },
  link: { text,type,parent,slug, ...restLinkProps },
}) => {
  const [isMobile] = useMediaQuery("(max-width:767px)");

  const borderRadius = {
    ...(!isMobile && {
      borderRadius: "0.375rem",
    }),
  };
  let prnt;
  type === "internal" || type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
    const ur = (prnt ?? "").concat(slug ?? "");
    let trg;
    type!='internal-other' &&  type!='external' ? trg="" : trg="_blank";
  return (
    <Link href={ur} title={text} target={trg} >
    <Box
      pos="relative"
      h="full"
      sx={{
        "@media screen and (max-width: 767px)": {
          bg: "#F0F2F5",
          borderRadius: "md",
          "> img": {
            borderTopRightRadius: "md",
            borderTopLeftRadius: "md",
          },
        },
        "@media screen and (min-width: 766px)": {
          "> img": {
            borderRadius: "md",
          },
        },
      }}
    >
      <AppImage
        src={url}
        alt={alt}
        title={alt}
        blurDataURL={base64}
        width={1920}
        height={850}
        style={{ width: "100%" }}
      />
      <Box
        as="div"
        {...descriptionWrapperStyle(borderRadius)}
        sx={{
          "@media screen and (max-width: 767px)": {
            ".whats-new__inner-wrapper > h4, .whats-new__inner-wrapper > a": {
              color: "black",
            },
            ".whats-new__inner-wrapper > a": {
              borderColor: "black",
            },
            borderBottomRightRadius: "md",
            borderBottomLeftRadius: "md",
          },
          "@media screen and (min-width: 766px)": {
            ".whats-new__inner-wrapper > h4, .whats-new__inner-wrapper > a": {
              color: "white",
            },
            bg: "blackAlpha.400",
            _hover: {
              bg: "blackAlpha.600",
            },
            borderTopLeftRadius: "md",
            borderBottomLeftRadius: "md",
          },
        }}
      >
        <Box
          as="div"
          {...descriptionInnerWrapperStyle}
          className="whats-new__inner-wrapper"
        >
          <KtHeading as="h4" mb={4}>
          
            {heading}
          </KtHeading>
          <Text
            as="p"
            fontSize={appTextFontSize}
            color={{
              base: "black",
              md: "white",
            }}
            dangerouslySetInnerHTML={{ __html: description }}
            opacity={1}
            mb="4"
          />
          <AppBox
            title={text}   type={type}  parent={parent}  slug = {slug}  {...restLinkProps}
            color={isMobile ? "black" : "white"}
            variant="pill"
            arrow
          >
            {text}
          </AppBox>
        </Box>
      </Box>
    </Box>
    </Link>
  );
};

export default WhatsNew;
