import { Box, Text, useMediaQuery } from "@chakra-ui/react";
import { BsDownload ,BsPlayCircle} from "react-icons/bs";


import { AppLink, KtHeading, AppImage } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import Link from "next/link";
export default function PhotoGallery({
  heading,
  description,
  image: { url, alt, base64 },
  link: { text,type,parent,slug, ...restLinkProps },
  hasExplore = false
}) {

  const [isMobile] = useMediaQuery(["(max-width: 991px)"], {
    ssr: true,
    fallback: true,
  });

  let prnt;
  type === "internal" || type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
    const ur = (prnt ?? "").concat(slug ?? "");
    let trg;
    type!='internal-other' &&  type!='external' ? trg="" : trg="_blank";    
  return (
    <Box
    pos="relative"
    h="full"
    sx={{
      "@media screen and (max-width: 767px)": {
        bg: "#F9FAFC",
        borderRadius: "md",
        "> img": {
          borderTopRightRadius: "md",
          borderTopLeftRadius: "md",
        },
      },
      "@media screen and (min-width: 766px)": {
        "> img": {
          borderRadius: "md",
        },
      },
    }}
  >
    {text ? (
        <Link href={ur} title={heading} target={trg} > 
        <AppImage
          src={url}
          alt={alt}
          title={alt}
          blurDataURL={base64}
          width={1280}
          height={720}
          style={{ width: "100%" }}
        />
        </Link>) : (<AppImage
          src={url}
          alt={alt}
          title={alt}
          blurDataURL={base64}
          width={1280}
          height={720}
          style={{ width: "100%" }}
        />)}
    <Box
     
      pos="absolute"
      top="50%"
      left="50%"
      transform="translate(-50%, -50%)"
      zIndex="1"
    >
      {(!isMobile) && 
      <Link href={ur} title={heading} target={trg} > 
      <BsPlayCircle size="70px" color="white" /> 
      </Link>
      }
    </Box>
    
    <Box
     opacity={0.75}
      pos={{
        base: "relative",
        md: "absolute",
      }}
      bg={{
        base: "#F9FAFC",
        md: "white",
      }}
      bottom={0}
      left={0}
      maxW={{
        base: "full",
        md: "md",
        lg: "567px",
      }}
      pt={{
        base: "10px",
        md: "50px",
      }}
      pb="50px"
      pl={{
        base: "10px",
        md: "20px",
        lg: "80px",
      }}
      pr={{
        base: "10px",
        md: "20px",
        lg: "80px",
      }}
    >
      <KtHeading as="h4" mb="2" color="black">
      <Link href={ur} title={heading} target={trg} >{heading}</Link>
      </KtHeading>
      <Text as="p" mb="3" fontSize={appTextFontSize}>
        {description}
      </Text>

      {text && (
        <AppLink
        title={heading}   type={type}  parent={parent}  slug = {slug}  {...restLinkProps}
          variant={hasExplore && restLinkProps.type !== "download" ? "unpill" : "pill"}
          color="black"
          arrow={restLinkProps.type !== "download"}
        >
          {text}
          {restLinkProps.type === "download" && <BsDownload />}
        </AppLink>)}
    </Box>
  </Box>

  );
}
