"use client";

import { Box, Flex, Text } from "@chakra-ui/react";
import {
  KtHeading,
  AppSection,
  AppLink,
  AppCarousel,
  AnimationWrapper,
  EmblaContainer,
  AppImage,
} from "@/app/_components";

import { pxToRem } from "@/app/_utils";
import { appTextFontSize } from "@/app/_components/_styles";

import {
  scaleVariant,
  hoverCardYVariant,
} from "@/app/_utils/animationVariants";

export default function VideoBgActivity({
  heading,
  description,
  video: { desktop_url },
  items,
  link: { text, ...restLinkProps },
  sectionProps,
}) {
  
  return (
    <AppSection {...sectionProps} explore>
      <Box as="div" pos="relative" height="4xl" w="full">
        <Box
          as="span"
          pos="absolute"
          w="full"
          h="full"
          bgGradient="linear(blackAlpha.600 0%, whiteAlpha.50 100%)"
        />
        <Box
          as="video"
          src={desktop_url}
          onContextMenu={(e) => e.preventDefault}
          preload="metadata"
          width="full"
          height="full"
          objectFit="cover"
          playsInline
          muted
          autoPlay
          loop
        />

        <Box
          pos="absolute"
          top={0}
          bottom={0}
          w="full"
          h="full"
          overflow={{
            base: "hidden",
            lg: "auto",
          }}
        >
          <Box
            display="grid"
            gridTemplateColumns={{
              base: "repeat(1, 1fr)",
              lg: "repeat(2, 1fr)",
            }}
            h="full"
          >
            <Flex
              justify={{
                base: "center",
                md: "flex-start",
                lg: "center",
              }}
              align="center"
              h="full"
              gap={{
                base: 3,
                lg: 3,
              }}
            >
              <Box
                as="div"
                w={{
                  base: "100%",
                  md: "sm",
                }}
                pt={{
                  base: 4,
                  sm: 4,
                }}
                pl={{
                  base: 4,
                  lg: 0,
                }}
                pr={{
                  base: 4,
                  lg: 0,
                }}
              >
                <KtHeading as="h2" color="white" mb={{ base: 3, md: 4 }}>
                  {heading}
                </KtHeading>
                <Text as="p" color="white" mb={4} fontSize={appTextFontSize}>
                  {description}
                </Text>
                { text != undefined && (
                <AppLink {...restLinkProps} variant="pill"  arrow>
                  {text}
                </AppLink>
                )}
              </Box>
                
            </Flex>
            <AppCarousel showArrows items={items} arrowPosition="VideoBGCenter">
              <EmblaContainer
                height={pxToRem(556)}
                mt={{
                  base: 4,
                  sm: 5,
                  lg: "calc(25% + 50px)",
                  xl: "calc(25% + 30px)",
                  "2xl": "calc(15% + 20px)",
                }}
              >
                {items.map(
                  ({
                    _id,
                    image: { url, alt, base64 },
                    heading,
                    link: memoryLink,
                  }) => (
                    <AppLink
                      title={memoryLink.title}
                      type={memoryLink.type}
                      parent={memoryLink.parent}
                      slug={memoryLink.slug}
                      flex={{
                        base: "0 0 96%",
                        sm: "0 0 320px",
                        lg: "0 0 360px",
                      }}
                      mr={{
                        base: "2%",
                        lg: 5,
                      }}
                      ml={{
                        base: "2%",
                        lg: 5,
                      }}
                      pos="relative"
                      key={_id}
                      borderRadius="2%"
                      overflow="hidden"
                    >
                      <AnimationWrapper
                        whileHover
                        animateRoot
                        h="full"
                        w="full"
                      >
                        <AnimationWrapper
                          overlay
                          overlayType="light"
                          variants={scaleVariant}
                          h="full"
                          pos="relative"
                          transition="0.4s linear"
                          sx={{
                            "> img": {
                              borderRadius: "md",
                            },
                          }}
                        >
                          <AppImage
                            src={url}
                            alt={alt}
                            title={alt}
                            blurDataURL={base64}
                            sizes="50vw"
                            style={{
                              width: "100%",
                              height: "100%",
                            }}
                            fill
                          />
                        </AnimationWrapper>
                        <AnimationWrapper
                          layout
                          variants={hoverCardYVariant}
                          pos="absolute"
                          bottom={0}
                          px={10}
                          py={5}
                          w="full"
                          transition="0.4s linear"
                        >
                          <KtHeading as="h6" color="white">
                            {heading}
                          </KtHeading>
                        </AnimationWrapper>
                      </AnimationWrapper>
                    </AppLink>
                  )
                )}
              </EmblaContainer>
            </AppCarousel>
          </Box>
        </Box>
      </Box>
    </AppSection>
  );
}
