import dynamic from "next/dynamic";
import {
  Grid,
  Box,
  Flex,
  Avatar,
  Text,
  Button,
  useDisclosure,
  GridItem,
} from "@chakra-ui/react";

import { BsExclamationCircle, BsFillPencilFill } from "react-icons/bs";
import { KtHeading, PlayIcon, AppLink, AppImage } from "@/app/_components";
import Link from "next/link";

const AppModal = dynamic(() =>
  import("@/app/_components").then((mod) => mod.AppModal)
);
const AppPlayer = dynamic(
  () => import("@/app/_components").then((mod) => mod.AppPlayer),
  { ssr: false }
);

import { pxToRem, isObjectEmpty } from "@/app/_utils";
import { appTextFontSize } from "@/app/_components/_styles";

export default function UsersStory({
  heading,
  description,
  video = {},
  image: { url, alt, base64 },
  author: { image, name, profile },
  link: { text,type,parent,slug, ...restLinkProps },
  ...restProps
}) {
  const { isOpen, onOpen, onClose } = useDisclosure();

  let prnt;
  type === "internal" || type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
    const ur = (prnt ?? "").concat(slug ?? "");
    let trg;
    type!='internal-other' &&  type!='external' ? trg="" : trg="_blank";  

  return (
    <>
      <Grid
        templateColumns={{
          base: "repeat(1, 1fr)",
          //lg: "repeat(2, 1fr)",
          lg: "1fr 2fr"
        }}
        autoFlow={{
          base: "row",
        }}
        h="full"
      >
        <GridItem pos="relative" overflow="hidden" w="full">
          {restProps?.userId && (
            <Box pos="absolute" right={0} m={6} zIndex={1}>
              <Flex gap={4}>
                {!restProps.isApproved && (
                  <Button
                    fontSize={{
                      base: "16px",
                      md: "24",
                    }}
                    bg="white"
                    gap={{
                      base: 2,
                      md: 4,
                    }}
                    py={{
                      base: 2,
                      md: 6,
                    }}
                    px={{
                      base: 4,
                      md: 8,
                    }}
                    rounded="full"
                    _hover={{
                      bg: "white",
                    }}
                    leftIcon={
                      <BsExclamationCircle fill="var(--kerala-tourism-colors-orangePeel-900)" />
                    }
                  >
                    Approval Pending
                  </Button>
                )}
                <Button
                  fontSize={{
                    base: "16px",
                    md: "24",
                  }}
                  bg="white"
                  gap={{
                    base: 2,
                    md: 4,
                  }}
                  py={{
                    base: 2,
                    md: 6,
                  }}
                  px={{
                    base: 4,
                    md: 8,
                  }}
                  rounded="full"
                  _hover={{
                    bg: "white",
                  }}
                  leftIcon={
                    <BsFillPencilFill fill="var(--kerala-tourism-colors-orangePeel-900)" />
                  }
                >
                  Edit
                </Button>
              </Flex>
            </Box>
          )}
          <Link href={ur} title={text} target={trg} >
          <AppImage
            src={url}
            alt={alt}
            title={alt}
            blurDataURL={base64}
            width={1280}
            height={720}
            style={{ height: "100%", width: "100%" }}
          /></Link>
        </GridItem>
        <GridItem
          bg="ghostWhite"
          py={{
            base: pxToRem(20),
            sm: pxToRem(40),
            lg: pxToRem(80),
          }}
          px={{
            base: pxToRem(15),
            sm: pxToRem(40),
            lg: pxToRem(80),
          }}
          display="flex"
          alignItems="center"
        >
          <Flex direction="column" gap={5}>
            <Flex gap={5} align="center">
              {/* <Avatar src={image} size="xl" /> */}
              <Flex direction="column">
                <Text as="h4">
                  <Text as="strong">{name}</Text>
                </Text>
                <Text fontSize={appTextFontSize}>{profile}</Text>
              </Flex>
            </Flex>
            <KtHeading as="h4"><Link href={ur} title={text} target={trg} >{heading}</Link></KtHeading>
            <Text as="p" pb={3} fontSize={appTextFontSize}>
              {description}
            </Text>
            <Flex justify="space-between" className="blog__more">
              <AppLink title={text}   type={type}  parent={parent}  slug = {slug}  {...restLinkProps} variant="pill" color="black" arrow>
                {text}
              </AppLink>
              {!isObjectEmpty(video) && (
                <Flex
                  as="span"
                  align="center"
                  justify="center"
                  sx={{
                    ".blog__more & svg ": {
                      color: "black",
                      fontWeight: "normal",
                      cursor: "pointer",
                    },
                  }}
                >
                  <Text as="strong" fontSize={appTextFontSize}>
                    Play video
                  </Text>
                  <Flex
                    onClick={() => onOpen()}
                    justify="center"
                    align="center"
                  >
                    <PlayIcon />
                  </Flex>
                </Flex>
              )}
            </Flex>
          </Flex>
        </GridItem>
      </Grid>
      {!isObjectEmpty(video) && (
        <AppModal
          modalProps={{
            maxW: {
              base: "18rem",
              sm: "30rem",
              md: "46rem",
              lg: "52rem",
              xl: "66rem",
              "2xl": "96rem",
            },
            maxH: {
              base: "100%",
            },
          }}
          modalBodyProps={{ p: 0 }}
          closeBtnProps={{
            zIndex: 99,
            pos: "absolute",
            top: "-10px",
            right: "-10px",
            color: "white",
            bg: "orangePeel.900",
            borderRadius: "full",
          }}
          isOpen={isOpen}
          onClose={onClose}
        >
          <AppPlayer type={video.type} url={video.url} />
        </AppModal>
      )}
    </>
  );
}
