import { Box, Text } from "@chakra-ui/react";
import { AppLink, KtHeading, AppImage } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import Link from "next/link";

const RelatedActivity = ({
  heading,
  description,
  image: { url, alt, base64 },
  link: { text,type,parent,slug, ...restLinkProps },
}) => {
  let prnt;
  type === "internal" || type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
    const ur = (prnt ?? "").concat(slug ?? "");
    let trg;
    type!='internal-other' &&  type!='external' ? trg="" : trg="_blank"; 


  return (
    <>
    <Link href={ur} title={heading} target={trg} >  
      <AppImage
        src={url}
        alt={alt}
        title={alt}
        blurDataURL={base64}
        width={562}
        height={315}
        style={{
          width: "100%",
          borderRadius: "var(--kerala-tourism-radii-md)",
          height: "auto",
        }}
      />
      </Link>
      <Box pt={5} pb={5} display="flex" flexDir="column" gap={5}>
        <KtHeading as="h4" color="black" fontSize="30px">
        <Link href={ur} title={heading} target={trg} >{heading} </Link>
        </KtHeading>
        <Text as="p" fontSize={appTextFontSize}>
          {description}
        </Text>
        <Box display="inline-flex">
          <AppLink title={heading}   type={type}  parent={parent}  slug = {slug}  {...restLinkProps} variant="pill" color="black" arrow>
            {text}
          </AppLink>
        </Box>
      </Box>
    </>
  );
};

export default RelatedActivity;
