import { Box, Text } from "@chakra-ui/react";

import { BsDownload ,BsPlayCircle} from "react-icons/bs";

import { AppLink, KtHeading, AppImage } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import Link from "next/link";
export default function PhotoVideoGallery({
  heading,
  description,
  image: { url, alt, base64 },
  link: { text,type,parent,slug, ...restLinkProps },
  hasExplore = false,
  itemType,
}) {

let prnt;
  type === "internal" || type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
    const ur = (prnt ?? "").concat(slug ?? "");
    let trg;
    type!='internal-other' &&  type!='external' ? trg="" : trg="_blank";   
  return (
    <Box
      pos="relative"
      h="full"
      sx={{
        "@media screen and (max-width: 767px)": {
          bg: "#F9FAFC",
          borderRadius: "md",
          "> img": {
            borderTopRightRadius: "md",
            borderTopLeftRadius: "md",
          },
        },
        "@media screen and (min-width: 766px)": {
          "> img": {
            borderRadius: "md",
          },
        },
      }}
      
    >
{text ? (
        <Link href={ur} title={heading} target={trg} > 
        <Box
  position="relative"
  display="inline-block"  // Ensures the box wraps around the image size
  w="full"  // Make sure the box takes full width if necessary
>
  <AppImage
    src={url}
    alt={alt}
    title={alt}
    blurDataURL={base64}
    width={699}
    height={393}
    
  />
  {itemType === "video" && (
  <Box
    position="absolute"
    top="50%"
    left="50%"
    transform="translate(-50%, -50%)"
    display="flex"
    alignItems="center"
    justifyContent="center"
    bg="rgba(0, 0, 0, 0.5)"  // Optional: semi-transparent background for contrast
    borderRadius="50%"       // Makes the play button circular
    width="50px"             // Set the width of the play button
    height="50px"            // Set the height of the play button
  >
    
     
      <BsPlayCircle size="70px" color="white" /> 
      
    
  </Box>
  )}
</Box>
        </Link>) : (<AppImage
          src={url}
          alt={alt}
          title={alt}
          blurDataURL={base64}
          width={699}
          height={393}
          style={{ width: "100%" }}
        />)}

     
      <Box
       opacity={0.75}
        pos={{
          base: "relative",
          md: "absolute",
        }}
        bg={{
          base: "#F9FAFC",
          md: "white",
        }}
        bottom={0}
        left={0}
        maxW={{
          base: "full",
          md: "md",
          lg: "567px",
        }}
        pt={{
          base: "10px",
          md: "10px",
        }}
        pb="10px"
        pl={{
          base: "10px",
          md: "10px",
          lg: "10px",
        }}
        pr={{
          base: "10px",
          md: "10px",
          lg: "10px",
        }}
        minHeight="50px"  // Minimum height set to 150px (adjust as needed)
        height="auto"     // Height adjusts based on content        
      >
        
        <Link href={ur} title={heading} target={trg} ><Text as="p">{heading}</Text></Link>
        
        
        {text && (
        <AppLink
        title={heading}   type={type}  parent={parent}  slug = {slug}  {...restLinkProps}
          variant={hasExplore && restLinkProps.type !== "download" ? "unpill" : "pill"}
          color="black"
          arrow={restLinkProps.type !== "download"}
        >
          {text}
          
        </AppLink>)}
      </Box>
    </Box>
  );
}
