import { pxToRem } from "@/app/_utils";

export const sliderSectionStyles = {
  pos: "relative",
  h: "100vh",
  _before: {
    content: "''",
    pos: "absolute",
    top: 0,
    left: 0,
    bottom: 0,
    zIndex: 1,
    w: "full",
    h: "full",
    
  },
  mb: {
    base: pxToRem(90 / 2),
    "2xl": pxToRem(90),
  },
};

export const sliderInfoWrapperStyles = {
  pos: "absolute",
  w: {
    base: "100%",
    lg: "lg",
  },
  right: {
    lg: "5%",
    md: 0,
    sm: "auto",
  },
  left: {
    lg: "auto",
    sm: 0,
  },
  bottom: {
    base: 0,
    lg: "50px",
  },
  p: {
    base: "15px",
    sm: "50px",
    lg: 0,
  },
  zIndex: 3,
};

export const ulStyle = {
  display: "flex",
  justifyItems: "center",
  alignItems: "center",
  styleType: "none",
  gap: 5,
  margin: 0,
};

export const listItemStyle = {
  pos: "relative",
  cursor: "pointer",
  color: "white",
  fontSize: {
    base: "14px",
    md: "16px",
  },
};

export const progressStyle = {
  colorScheme: "orange",
  sx: {
    height: "1px",
    pos: "absolute",
    top: 0,
    left: 0,
    width: "full",
  },
};
