// VideoPlayer.jsx
import { forwardRef } from "react";
import { Box } from "@chakra-ui/react";
import { motion } from "framer-motion";

const VideoPlayer = forwardRef(
  ({ activeSliderId, url, poster_image, onTimeUpdate, onEnded, audioState}, ref) => {
    return (
      <Box
        as={motion.div}
        key={activeSliderId}
        height="full"
        width="full"
        overflow="hidden"
      >
        <video
            key={activeSliderId}
            height="full"
            width="full"
            objectFit="cover"
            ref={ref}
            src={url}
            poster={poster_image}
            preload="metadata"
            onContextMenu={(e) => e.preventDefault()}
            onTimeUpdate={onTimeUpdate}
            onEnded={onEnded}
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition="0.5s linear"
            playsInline
            muted={audioState}
            autoPlay
            style={{ objectFit: "cover", width: "100%", height: "100%" }}
          />
      </Box>
    );
  }
);

VideoPlayer.displayName = "VideoPlayer";

export default VideoPlayer;
