import { Box, Flex } from "@chakra-ui/react";
import {
  IconWrapper,
  PlayIcon,
  PauseIcon,
  VolumeIcon,
  VolumeMuteIcon,
} from "@/app/_components";

export default function VideoControls({
  playing,
  audioState,
  handleVideoStates,
}) {
  return (
    <Box as="div">
      <Flex gap={2} justify="center" align="center" h="full">
        <IconWrapper
          onClick={() => handleVideoStates(playing ? "pause" : "play")}
        >
          {playing ? <PauseIcon /> : <PlayIcon /> }
        </IconWrapper>
        <IconWrapper onClick={() => handleVideoStates("audio")}>
          {audioState ? <VolumeMuteIcon /> : <VolumeIcon />}
        </IconWrapper>
      </Flex>
    </Box>
  );
}
