import { useMemo } from "react";

import { Box, Flex, UnorderedList, ListItem, Progress } from "@chakra-ui/react";
import { IconWrapper, LeftIcon, RightIcon } from "@/app/_components";
import { ulStyle, listItemStyle, progressStyle } from "../_styles";

export default function SliderNavigation({
  sliders,
  noOfSlider,
  activeSliderId,
  playPercentage,
  handleSelectSlider,
  handlePrev,
  handleNext,
  direction,
  setDirection
}) {

  const arrowStyle = useMemo(() => ({
    sx: {
      ".left-icon svg": {
        color: direction ? "white" : "orangePeel.900"
      },
      ".right-icon svg": {
        color: direction ? "orangePeel.900" : "white"
      }
    }
  }), [direction]);


  return (
    <Box as="div" h="60px" sx={{
      "svg": {
        fontSize: "18px"
      }
    }}>
      <Flex justify={{ sm: "start", lg: "end" }} align="center" h="full" {...arrowStyle}>
        <IconWrapper border={false} onClick={() => handlePrev()} className="left-icon">
          <LeftIcon className="left" />
        </IconWrapper>
        <UnorderedList {...ulStyle}>
          {sliders.slice(0, noOfSlider).map(({ _id, heading }, index) => (
            <ListItem
              key={_id}
              onClick={() => handleSelectSlider(index)}
              {...listItemStyle}
            >
              <Progress
                value={activeSliderId === _id ? playPercentage : 0}
                {...progressStyle}
                isAnimated
                hasStripe
              />
              {heading}
            </ListItem>
          ))}
        </UnorderedList>
        <IconWrapper border={false} onClick={() => handleNext()} className="right-icon">
          <RightIcon />
        </IconWrapper>
      </Flex>
    </Box>
  );
}
