import { Box, Divider, Text } from "@chakra-ui/react";
import { KtHeading, AppLink, AnimationWrapper } from "@/app/_components";

import { appTextFontSize } from "@/app/_components/_styles";
import { pxToRem } from "@/app/_utils";

export default function SliderDescription({
  heading,
  description,
  link: { text, ...restProps },
}) {
  return (
    <AnimationWrapper
      color="white"
      pb="10px"
      initial={{ x: 100, opacity: 0 }}
      animate={{ x: 0, opacity: 1 }}
      exit={{ x: -100, opacity: 0 }}
      animateRoot
    >
      <Box
        as="div"
        pos="relative"
        sx={{
          "@media screen and (max-width:992px)": {
            ".slider-description__divider": {
              display: "none",
            },
          },
        }}
      >
        <Divider
          className="slider-description__divider"
          orientation="vertical"
          h="95%"
          pos="absolute"
          top={pxToRem(10)}
        />
        <Box
          pl={{
            base: 0,
            md: 4,
          }}
        >
          <KtHeading as="h6" color="white" mb={2}>
            {heading}
          </KtHeading>
          <Text mb={4} fontSize={appTextFontSize}>
            {description}
          </Text>
          <AppLink {...restProps} variant="pill" arrow>
            {text}
          </AppLink>
        </Box>
      </Box>
    </AnimationWrapper>
  );
}
