import dynamic from "next/dynamic";
import {
  Grid,
  Box,
  Flex,
  Avatar,
  Text,
  Button,
  useDisclosure,
  GridItem,
} from "@chakra-ui/react";
import { BsDownload } from "react-icons/bs";
import { BsExclamationCircle, BsFillPencilFill } from "react-icons/bs";
import { KtHeading, PlayIcon, AppLink, AppImage } from "@/app/_components";
import Link from "next/link";
const AppModal = dynamic(() =>
  import("@/app/_components").then((mod) => mod.AppModal)
);
const AppPlayer = dynamic(
  () => import("@/app/_components").then((mod) => mod.AppPlayer),
  { ssr: false }
);

import { pxToRem, isObjectEmpty } from "@/app/_utils";
import { appTextFontSize } from "@/app/_components/_styles";

export default function Ebrochures({
  heading,
  description,
  image: { url, alt, base64 },
  link: { text,type,parent,slug, ...restLinkProps },
  hasExplore = false
}) {
  let prnt;
  type === "internal" || type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
    const ur = (prnt ?? "").concat(slug ?? "");
    let trg;
    type!='internal-other' &&  type!='external' ? trg="" : trg="_blank"; 

  return (
    <>
      <Grid
        templateColumns={{
          base: "repeat(1, 1fr)",
          lg: "1fr 2fr",
        }}
        autoFlow={{
          base: "row",
        }}
        h="full"
      >
        <GridItem pos="relative" overflow="hidden" w="full">
        {text ? (
        <Link href={ur} title={heading} target={trg} >           
          <AppImage
            src={url}
            alt={alt}
            blurDataURL={base64}
            width={500}
            height={500}
            style={{ height: "100%", width: "100%" }}
          />
        </Link>) : (<AppImage
            src={url}
            alt={alt}
            blurDataURL={base64}
            width={500}
            height={500}
            style={{ height: "100%", width: "100%" }}
          />)}          
        </GridItem>
        <GridItem
          bg="ghostWhite"
          py={{
            base: pxToRem(20),
            sm: pxToRem(40),
            lg: pxToRem(80),
          }}
          px={{
            base: pxToRem(15),
            sm: pxToRem(40),
            lg: pxToRem(80),
          }}
          display="flex"
          alignItems="center"
        >
          <Flex direction="column" gap={5}>
            
            <KtHeading as="h4"><Link href={ur} title={heading} target={trg} >{heading}</Link></KtHeading>
            <Text as="p" pb={3} fontSize={appTextFontSize}>
              {description}
            </Text>
            <Flex justify="space-between" className="blog__more">
            {text && (
        <AppLink
        title={heading}   type={type}  parent={parent}  slug = {slug}  {...restLinkProps}
          variant={hasExplore && restLinkProps.type !== "download" ? "unpill" : "pill"}
          color="black"
          arrow={restLinkProps.type !== "download"}
        >
          {text}
          {restLinkProps.type === "download" && <BsDownload />}
        </AppLink>)}
              
            </Flex>
          </Flex>
        </GridItem>
      </Grid>
      
    </>
  );
}
