import dynamic from "next/dynamic";
import { Card, Box, Flex, Avatar, Text } from "@chakra-ui/react";

const Rating = dynamic(
  () => import("@/app/_components").then((mod) => mod.Rating),
  { ssr: false }
);

export default function CustomerReview({
  rating,
  createdAt,
  review,
  author: { image, name },
}) {
  return (
    <Card
      bg="ghostWhite"
      p={{
        base: 4,
        lg: 10,
      }}
    >
      <Flex align="center" justify="center" direction="column" gap={3} mb={3}>
        <Rating rating={rating} starDimension="35px" starSpacing="5px" />
        <Text as="span">$.{rating} Ratings</Text>
      </Flex>
      <Flex align="center" gap={5} mb={3}>
        <Avatar src={image} size="xl" />
        <Box as="div">
          <Text as="p" fontWeight="bold">
            {name}
          </Text>
          <Text as="span">{createdAt}</Text>
        </Box>
      </Flex>
      <Box>
        <Text as="p">{review}</Text>
      </Box>
    </Card>
  );
}
