import { string, shape } from "prop-types";
import {
  KtHeading,
  AppImage,
  AppLink,
  AnimationWrapper,
} from "@/app/_components";

import {
  scaleVariant,
  hoverCardYVariant,
} from "@/app/_utils/animationVariants";

const Activity = ({ heading, image: { url, alt, base64 }, link }) => {
  return (
    <AppLink
      {...link}
      display="flex"
      h="full"
      pos="relative"
      overflow="hidden"
      borderRadius="2%"
    >
      <AnimationWrapper animateRoot whileHover h="full" w="full">
        <AnimationWrapper
          variants={scaleVariant}
          overlay
          overlayType="dark"
          h="full"
          transition="0.4s linear"
          pos="relative"
          sx={{
            "> img": {
              borderRadius: "md"
            }
          }}
        >
          <AppImage
            src={url}
            alt={alt}
            title={alt}
            blurDataURL={base64}
            sizes="50vw"
            style={{
              objectFit: "cover",
            }}
            fill
          />
        </AnimationWrapper>
        <AnimationWrapper
          layout
          variants={hoverCardYVariant}
          pos="absolute"
          bottom={0}
          px={{
            base: 6,
            md: 10,
          }}
          py={5}
          zIndex={5}
          w="full"
          transition="0.4s linear"
        >
          <KtHeading as="h6" color="white">
            {heading}
          </KtHeading>
        </AnimationWrapper>
      </AnimationWrapper>
    </AppLink>
  );
};

Activity.propTypes = {
  heading: string.isRequired,
  image: shape({
    url: string.isRequired,
    alt: string.isRequired,
  }).isRequired,
};

export default Activity;
