import { SLIDER_CATEGORIES } from "@/app/_constants/componentConstant";

import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";
import Slider from ".";

const {
  MAIN_SLIDER,
  CUSTOMER_REVIEW_SLIDER,
  INFORMATION_SLIDER,
  TOUR_PACKAGE_SLIDER,
  PHOTO_VIDEO_GALLERY,  
} = SLIDER_CATEGORIES;

export async function SliderLoader(props) {
  const {
    block: { category },
  } = props;

  let reducedResults = props;

  if (
    ![
      MAIN_SLIDER,
      CUSTOMER_REVIEW_SLIDER,
      INFORMATION_SLIDER,
      TOUR_PACKAGE_SLIDER,
      PHOTO_VIDEO_GALLERY,      
    ].some((c) => c === category)
  ) {

    const items = props.items;
     
    const blurImagePromise = items.map(({ image: { url } }) =>
      getBase64ImageUrl(url)
    );

    const imageWithBlurDataUrls = await Promise.all(blurImagePromise);

    for (let i = 0; i < items.length; i++) {
      items[i].image = {
        ...items[i].image,
        base64: imageWithBlurDataUrls[i],
      };
    }

    reducedResults = {
      ...reducedResults,
      items,
    };
  }

  if (
    [
      PHOTO_VIDEO_GALLERY,      
    ].some((c) => c === category)
  ) {

    const itemsPhotos = props.itemsPhotos;
     
    const blurImagePromise1 = itemsPhotos.map(({ image: { url } }) =>
      getBase64ImageUrl(url)
    );

    const imageWithBlurDataUrls1 = await Promise.all(blurImagePromise1);

    for (let i = 0; i < itemsPhotos.length; i++) {
      itemsPhotos[i].image = {
        ...itemsPhotos[i].image,
        base64: imageWithBlurDataUrls1[i],
      };
    }

    reducedResults = {
      ...reducedResults,
      itemsPhotos,
    };

    const itemsVideos = props.itemsVideos;
     
    const blurImagePromise2 = itemsVideos.map(({ image: { url } }) =>
      getBase64ImageUrl(url)
    );

    const imageWithBlurDataUrls2 = await Promise.all(blurImagePromise2);

    for (let i = 0; i < itemsVideos.length; i++) {
      itemsVideos[i].image = {
        ...itemsVideos[i].image,
        base64: imageWithBlurDataUrls2[i],
      };
    }

    reducedResults = {
      ...reducedResults,
      itemsVideos,
    };    
  }
  return <Slider {...reducedResults} />;
}
