"use client";

import { AppSection, KtContainer } from "@/app/_components";

import ProfileInfo from "./_components/ProfileInfo";
import UploadStory from "./_components/UploadStory";

import { PROFILE_CATEGORIES } from "@/app/_constants/componentConstant";

const { PROFILE_INFO, UPLOAD_STORY } = PROFILE_CATEGORIES;

export default function Profile({ block: { category }, ...restProps }) {
  return (
    <AppSection>
      <KtContainer>
        {(() => {
          switch (category) {
            case PROFILE_INFO:
              return <ProfileInfo {...restProps.user_info} />;
            case UPLOAD_STORY:
              return <UploadStory {...restProps} />;
            default:
              return null;
          }
        })()}
      </KtContainer>
    </AppSection>
  );
}
