import Link from "next/link";
import { BsCamera, BsPlus } from "react-icons/bs";
import {
  IconButton,
  Button,
  Link as ChakraLink,
  Avatar,
} from "@chakra-ui/react";
import { appTextFontSize } from "@/app/_components/_styles";

export function UserAvatar({ avatar_url, width = 64, height = 64, children }) {
  return (
    <Avatar
      src={avatar_url}
      width={{
        base: "150px",
        lg: width,
      }}
      h={{
        base: "150px",
        lg: height,
      }}
    >
      {children}
    </Avatar>
  );
}

export function UploadIcon(props) {
  return (
    <IconButton
      pos="absolute"
      bg="blackAlpha.500"
      backdropFilter="blur(10px)"
      _active={{
        bg: "blackAlpha.600",
      }}
      _hover={{
        bg: "blackAlpha.600",
      }}
      zIndex={1}
      fontSize={24}
      icon={<BsCamera fill="var(--kerala-tourism-colors-orangePeel-900)" />}
      {...props}
      isRound
    />
  );
}

export function ActionButton({ children, href }) {
  return (
    <Link passHref legacyBehavior href={href}>
      <Button
        as={ChakraLink}
        size="sm"
        variant="outline"
        borderRadius="full"
        borderColor="black"
        rightIcon={<BsPlus fontSize={30} />}
        fontSize={appTextFontSize}
      >
        {children}
      </Button>
    </Link>
  );
}
