import { Flex } from "@chakra-ui/react";

import { UserAvatar } from "../_common";
import { UserInfo } from "../ProfileInfo/_includes";

import FileUploader from "./_components/FileUploader";
import StoryInput from "./_components/StoryInput";

export default function UploadStory({
  user_info: { avatar_url, ...restProps },
}) {
  return (
    <>
      <Flex gap={8} align="center" pb={8} direction={{
        base: "column",
        md: "row"
      }}>
        <UserAvatar avatar_url={avatar_url} width={48} height={48} />
        <UserInfo {...restProps} />
      </Flex>
      <Flex gap={4} direction={{
        base: "column",
        md: "row"
      }}>
        <FileUploader type="image" />
        <FileUploader type="video" />
      </Flex>
      <StoryInput />
    </>
  );
}
