import {
  Flex,
  Box,
  FormControl,
  Textarea,
  Input,
  FormHelperText,
} from "@chakra-ui/react";

import { AppButton } from "@/app/_components";

export default function StoryInput() {
  return (
    <Box
      maxW={{
        base: "full",
        lg: "40%",
      }}
      mx="auto"
      mt={16}
    >
      <Flex
        direction="column"
        gap={6}
        sx={{
          button: {
            display: "inline-flex",
            width: "50%",
            mx: "auto",
          },
        }}
      >
        <FormControl>
          <Input
            variant="flushed"
            focusBorderColor="orangePeel.900"
            placeholder="Heading"
            _placeholder={{
              fontSize: "30",
            }}
          />
          <FormHelperText color="#ED8D7B" fontSize="14">
            30 characters
          </FormHelperText>
        </FormControl>
        <FormControl>
          <Textarea
            variant="flushed"
            focusBorderColor="orangePeel.900"
            placeholder="Description"
            _placeholder={{
              fontSize: "30",
            }}
            rows={10}
            resize="none"
          />
          <FormHelperText color="#ED8D7B" fontSize="14">
            120 characters
          </FormHelperText>
        </FormControl>
        <AppButton>Submit</AppButton>
      </Flex>
    </Box>
  );
}
