import { oneOf } from "prop-types";
import { Box, Button, Text, Flex } from "@chakra-ui/react";
import { useDropzone } from "react-dropzone";
import { BsPlus } from "react-icons/bs";

export default function FileUploader({ type }) {
  const { getRootProps, getInputProps, open } = useDropzone({
    noClick: true,
    noKeyboard: true,
  });

  return (
    <Box
      h={{
        base: "350",
        lg: "780",
      }}
      flexBasis="full"
      position="relative"
      borderRadius="lg"
      backgroundImage="url(/images/profile/upload-bg.jpg)"
      backgroundRepeat="no-repeat"
      backgroundSize="cover"
      _before={{
        content: "''",
        pos: "absolute",
        borderRadius: "lg",
        top: 0,
        left: 0,
        bottom: 0,
        zIndex: 1,
        w: "full",
        h: "full",
        bgGradient: "linear(to-b, blackAlpha.100, blackAlpha.900)",
      }}
      sx={{
        ".dropFile": {
          pos: "relative",
          h: {
            base: "inherit",
            md: "full",
            lg: "full"
          },
          display: "flex",
          alignItems: "center",
          justifyContent: "center",
          zIndex: 2,
          border: "1px dashed white",
          borderRadius: "lg",
        },
      }}
      p={4}
    >
      <Box {...getRootProps({ className: "dropFile" })}>
        <input {...getInputProps()} />
        <Flex direction="column" gap={4}>
          <Text color="white" fontSize="30" textAlign="center">
            Drag & drop <br /> {type === "image" ? "Image" : "Video"}
          </Text>
          <Button
            fontSize="20"
            fontWeight="normal"
            bg="transparent"
            _hover={{
              bg: "transparent",
              color: "orangePeel.900",
            }}
            color="white"
            variant="outline"
            borderRadius="full"
            borderColor="orangePeel.900"
            rightIcon={<BsPlus fontSize={30} />}
            onClick={open}
          >
            Upload your {type === "image" ? "photo" : "video"}
          </Button>
        </Flex>
      </Box>
    </Box>
  );
}

FileUploader.propTypes = {
  type: oneOf(["image", "video"]).isRequired,
};
