import { Box, Flex } from "@chakra-ui/react";
import { AvatarInfo, ProfileCover, UserInfo, UserMenu } from "./_includes";



//export default function ProfileInfo({ cover_image, avatar_url, ...restProps }) {

//export const getMystoryInfo = async (slug) => {
const ProfileInfo = async( cover_image, avatar_url, ...restProps ) =>{


  return (
    <Box pos="relative">
      <ProfileCover cover_image={cover_image} />
      <Box pos="relative" w="full" top="-75">
        <Flex
          gap={6}
          direction={{
            base: "column",
            lg: "row",
          }}
        >
          <AvatarInfo avatar_url={avatar_url} />
          <Flex
            flex={1}
            pt={{
              base: 0,
              lg: "100",
            }}
            justifyContent="space-between"
          >
            <UserInfo {...restProps} />
            <UserMenu  session={session}/>
          </Flex>
        </Flex>
      </Box>
    </Box>
  );
}
export default ProfileInfo;