import {
  Box,
  IconButton,
  Popover,
  PopoverTrigger,
  PopoverContent,
  PopoverArrow,
  PopoverBody,
  List,
  ListItem,
  ListIcon,
  Link as ChakraLink,
} from "@chakra-ui/react";
import {
  BsFillPencilFill,
  BsBoxArrowRight,
  BsThreeDotsVertical,
  BsBell,
} from "react-icons/bs";

const userMenu = [
  {
    title: "Edit Profile",
    key: "edit-profile",
    href: "#",
    icon: BsFillPencilFill,
  },
  {
    title: "Logout",
    key: "logout",
    href: "#",
    icon: BsBoxArrowRight,
  },
  {
    title: "Notification",
    key: "notification",
    href: "#",
    icon: BsBell,
  },
];

export default function UserMenu(session) {
  return (
    <Box pr={6}>
      <Popover placement="bottom-end">
        <PopoverTrigger>
          <IconButton
            bg="transparent"
            _hover={{ bg: "transparent" }}
            _active={{ bg: "transparent" }}
            size="md"
            icon={
              <BsThreeDotsVertical fill="var(--kerala-tourism-colors-orangePeel-900)" />
            }
            border="1px solid black"
            isRound
          />
        </PopoverTrigger>
        <PopoverContent w="50">
          <PopoverArrow bg="#EFF3F7" />
          <PopoverBody bg="#EFF3F7">
            <Box py={4} px={4}>
              <List display="flex" flexDirection="column" gap={4}>
                {userMenu.map(({ title, key, href, icon }) => (       
                  
                title=='Logout' ?
                  session?.user ? (
                    <>
                      <ListItem color="#4D4D4D" key={key}>
                        <ChakraLink
                          display="inline-flex"
                          alignItems="center"
                          gap={4}
                          fontSize="24"
                          fontWeight="medium"
                          href={href}
                        >
                          <ListIcon as={icon} color="orangePeel.900" />
                          {title}
                        </ChakraLink>
                      </ListItem>
                    </>
                  ) : ''
                : (<ListItem color="#4D4D4D" key={key}>
                        <ChakraLink
                          display="inline-flex"
                          alignItems="center"
                          gap={4}
                          fontSize="24"
                          fontWeight="medium"
                          href={href}
                        >
                          <ListIcon as={icon} color="orangePeel.900" />
                          {title}
                        </ChakraLink>
                      </ListItem>) 
                   ))}
              </List>
            </Box>
          </PopoverBody>
        </PopoverContent>
      </Popover>
    </Box>
  );
}
