import { string } from "prop-types";
import { ReactSVG } from "react-svg";
import { Flex, Box, Text } from "@chakra-ui/react";

import { KtHeading } from "@/app/_components";

export default function UserInfo({
  full_name,
  designation,
  contact_no,
  email,
}) {
  return (
    <Flex direction="column" gap={6}>
      <Box>
        <KtHeading as="h2" color="black">
          {full_name}
        </KtHeading>
        <Text as="span" color="#232426">
          {designation}
        </Text>
      </Box>
      {contact_no && email && (
        <Flex
          gap={{
            base: 4,
            md: 8,
          }}
          direction={{
            base: "column",
            md: "row",
          }}
          sx={{
            "svg path": {
              stroke: "var(--kerala-tourism-colors-orangePeel-900)",
            },
            ".mail svg path": {
              fill: "var(--kerala-tourism-colors-orangePeel-900)",
            },
          }}
        >
          <Flex gap={4} align="center">
            <ReactSVG src="/icons/contact.svg" className="contact" />
            <Text as="span" color="#232426">
              {contact_no}
            </Text>
          </Flex>
          <Flex gap={4} align="center">
            <ReactSVG src="/icons/mail.svg" className="mail" />
            <Text as="span" color="#232426">
              {email}
            </Text>
          </Flex>
        </Flex>
      )}
    </Flex>
  );
}

UserInfo.propTypes = {
  full_name: string.isRequired,
  designation: string.isRequired,
  contact_no: string,
  email: string,
};
