import { string } from "prop-types";
import { Box } from "@chakra-ui/react";
import { AppImage } from "@/app/_components";

import { UploadIcon } from "../../_common";

export default function ProfileCover({ cover_image }) {
  return (
    <Box
      pos="relative"
      h={{
        base: "200",
        sm: "300",
        lg: "500",
      }}
    >
      <UploadIcon
        top={{
          base: 4,
          md: 8,
        }}
        right={{
          base: 4,
          md: 8,
        }}
      />
      <AppImage
        src={cover_image}
        alt="Profile Cover"
        title="Profile Cover"
        sizes="100vw"
        style={{ borderRadius: "10px" }}
        fill
      />
    </Box>
  );
}

ProfileCover.propTypes = {
  cover_image: string.isRequired,
};
