import { Flex, Avatar } from "@chakra-ui/react";

import { UploadIcon, ActionButton, UserAvatar } from "../../_common";

const actionUrls = [
  {
    title: "Plan a trip",
    href: "#",
  },
  {
    title: "Publish your trip",
    href: "/profile/upload-stories",
  },
];

export default function AvatarInfo({ avatar_url }) {
  return (
    <Flex
      p={6}
      direction="column"
      align="center"
      gap={6}
    >
      <UserAvatar avatar_url={avatar_url}>
        <UploadIcon
          right={{
            base: 1,
            lg: 4
          }}
          top={{
            base: 2,
            lg: 4,
          }}
        />
      </UserAvatar>
      <Flex
        gap={2}
        direction={{
          base: "column",
          sm: "row",
        }}
      >
        {actionUrls.map(({ title, href }, idx) => (
          <ActionButton key={idx} href={href}>
            {title}
          </ActionButton>
        ))}
      </Flex>
    </Flex>
  );
}
