"use client";

import { useState, useEffect, useCallback } from "react";
import { string, shape } from "prop-types";
import { useSearchParams } from "next/navigation";
import { useParams } from "next/navigation";
import { useRouter } from 'next/navigation'

import { Box } from "@chakra-ui/react";
import { getFilterInfo } from "@/app/_libs/loadFilter";

import {
  KtContainer,
  SectionHeading,
  AppSection,
  AppPagination,
} from "@/app/_components";
import { isObjectEmpty } from "@/app/_utils";

import { COMPONENT_TYPES } from "@/app/_constants/componentConstant";

import { ListFilter } from "../Filter";
import { ListTabs, PlanYourItineraryTabList } from "./_components/TabList";

import CategoryList from "./_components/CategoryList";

import AskQuery from "./_components/Itinerary/AskQuery";
import AiSuggestion from "./_components/Itinerary/AiSuggestion";

const { LIST } = COMPONENT_TYPES;



export default function List({
  block,
  heading,
  description,
  items,
  tabList,
  ai_suggestion = "",
  filters = {},
  link = {},
  scroll_key="",
  _id
}) {
  const router = useRouter();
  const { type, category, filter_for, noOfItems,noOfPageItems, ...restBlockProps } = block;

  /*console.log("Z: 1");
  console.log(type);
  console.log("Z: 2");*/
  const [filterlist,setFilterlist]=useState(filters);
  
  const [activeTabList, setActiveTabList] = useState(() =>
    tabList instanceof Array && tabList.length > 0 ? tabList[0]["key"] : ""
  );

  const [activeCategory, setActiveCategory] = useState(category);

  const [listItems, setListItems] = useState(() => {
    if (typeof items !== "undefined") return items;
    else return tabList[0].items;
  });

  const [selectedValues, setSelectedValues] = useState({}); //KRIPA

  /*function change_url(rg, dst)
  {

    if(dst > 0)
    {
      router.push('/'+params.slug[0]+'/'+params.slug[1]+'?Region='+rg+'&Districts='+dst, undefined, { shallow: true });
    }
    else
    {
      router.push('/'+params.slug[0]+'/'+params.slug[1]+'?Region='+rg, undefined, { shallow: true });
    }
  }*/

  function convertKeys(selectedValues) {
    const convertedValues = {};

    for (const key in selectedValues) {
      if (Object.hasOwnProperty.call(selectedValues, key)) {
        const convertedKey = key.toLowerCase().replace(/\s/g, "-");
        convertedValues[convertedKey] = selectedValues[key];
      }
    }

    return convertedValues;
  }

  // const handlePrimaryFilterChange = (selectedValues) => {
    
  //   setSelectedValues((prevValues) => ({
  //     ...prevValues,
  //     ...selectedValues,
  //   }));
  // };
  const params = useParams();
  //const handlePrimaryFilterValueChange = async (label,val) => { 
  const handlePrimaryFilterChange = async (selectedData,labelchanged) => { 
    //alert("test 1");
    let selectedValues = {};
    var rg = 0;
    var dst = 0;

   if(labelchanged=='region' || labelchanged=='districts') {

      //document.getElementById("destinations-in-north-kerala").style.display = 'block'; // Ajith
      //document.getElementById("destinations-in-south-kerala").style.display = 'block'; // Ajith
      //document.getElementById("destinations-in-central-kerala").style.display = 'block'; // Ajith

    const hln = document.getElementById("destinations-in-north-kerala");
    const hls = document.getElementById("destinations-in-south-kerala");
    const hlc = document.getElementById("destinations-in-central-kerala");

    if(labelchanged=='region') {

      if(hln)
        document.getElementById("destinations-in-north-kerala").style.display = 'block'; // Ajith
      if(hls)
        document.getElementById("destinations-in-south-kerala").style.display = 'block'; // Ajith
      if(hlc)
        document.getElementById("destinations-in-central-kerala").style.display = 'block'; // Ajith

    }

    let label;
    let val;
    let st="";
      if(Object.keys(selectedData).length>0){

        if(Object.keys(selectedData).length===1){
          label=Object.keys(selectedData)[0];
          val=Object.values(selectedData)[0];
          if(val) st='&'+label+'='+val;   
          
          if(label == "region") //Ajith
            {
              if(val == 1)
              {
                if(hln) document.getElementById("destinations-in-north-kerala").style.display = 'none'; // Ajith
              }
              else if(val == 2)
              {
                if(hls) document.getElementById("destinations-in-south-kerala").style.display = 'none'; // Ajith
              }
              else if(val == 3)
              {
                if(hlc) document.getElementById("destinations-in-central-kerala").style.display = 'none'; // Ajith
              }

              rg = val;
            }
            if(label == "districts")
            {
              dst = val;
            }
        }
        else if(Object.keys(selectedData).length>1 && selectedData.hasOwnProperty("region")){        
          if(labelchanged===Object.keys(selectedData)[0])
          {
            label=Object.keys(selectedData)[0];
            val=Object.values(selectedData)[0];
            if(val) st='&'+label+'='+val;
            
            if(label == "region") //Ajith
            {
              if(val == 1)
              {
                if(hln) document.getElementById("destinations-in-north-kerala").style.display = 'none'; // Ajith
              }
              else if(val == 2)
              {
                if(hls) document.getElementById("destinations-in-south-kerala").style.display = 'none'; // Ajith
              }
              else if(val == 3)
              {
                if(hlc) document.getElementById("destinations-in-central-kerala").style.display = 'none'; // Ajith
              }

              rg = val;
            }
            if(label == "districts")
            {
              dst = val;
            }
          }
          else{
            for (let key in selectedData) {
              let value = selectedData[key];
              if(value) st+='&'+key+'='+value; 

              if(key == "region")
              {  
                rg = value;
              } 
              if(key == "districts")
              {  
                dst = value;
              }
            }
          }        
             
        }
        else{       
          for (let key in selectedData) {
            let value = selectedData[key];
            if(value) st+='&'+key+'='+value;  
            
            if(key == "region")
            {  
              rg = value;
            } 
            if(key == "districts")
            {  
              dst = value;
            }
          }    
        }

       /* if(val > 0)
        {
          rg = val;
        }*/
      }

      //alert("District 1 : ");

      const result = await getFilterInfo(params.slug[0],params.slug[1],st);
      
      setFilterlist(result); 
      const { primary_filters } = result; 
      
      // Extracting selected values from the primary filters
     
      setSelectedValues({});
      primary_filters.forEach(filter => {
        const selectedOption = filter.options.find(option => option.selected);
        if (selectedOption) {
          selectedValues[filter.label.toLowerCase().replace(/\s/g, "-")] = selectedOption.value;
        }
      });
   }
   else{
    selectedValues=selectedData;
   }
    

    // Update the selected values state
    setSelectedValues(prevValues => ({
      ...prevValues,
      ...selectedValues
    }));
    
    //console.log("yyzz: ", rg, dst);
    if(params.slug[0] == "destination" || params.slug[0] == "where-to-stay")
    {
      if(rg == '') rg = 0;
      if(dst == '') dst = 0;

      if(dst > 0)
      {
        router.push('/'+params.slug[0]+'/'+params.slug[1]+'?Region='+rg+'&Districts='+dst, undefined, { shallow: true });
      }
      else
      {
        router.push('/'+params.slug[0]+'/'+params.slug[1]+'?Region='+rg, undefined, { shallow: true });
      }
      //change_url(rg, dst);
      
    }

  };

  

  function filterListItems(selectedValues, listItems) {
    return listItems.filter((item) => {
      return Object.entries(selectedValues)
        .filter(([key, value]) => value !== "")
        .every(([key, value]) => {
          if (Array.isArray(value)) {
            return (
              value.length === 0 ||
              value.some((element) => item[key] == element)
            );
          } else {
            return item[key] == value;
          }
        });
    });
  }

  const handlePrimaryFilterClear = (primary_filters) => {
    setSelectedValues({});
    setFilterlist(filters); 
    
    primary_filters.forEach(({ label, type }) => {
      const element = document.getElementsByName(
        label.toLowerCase().replace(/\s/g, "-")
      )[0];
      if (element !== undefined && element !== null) {
        if (type === "multi-select") {
          element.value = [];
          const selectInstance = window.selectInstances[element.id];
          if (selectInstance) {
            selectInstance.clear();
          }
        } else {
          element.value = "";
        }
      }
    });
  };

  const searchParams = useSearchParams();
  
  let convertedValues;
  useEffect(() => {
    const paramsObject = Object.fromEntries(searchParams);
    convertedValues = convertKeys(paramsObject);
    if(convertedValues.region == 0)  //Ajith if portion full
    {
      convertedValues.region = "";
    }
    setSelectedValues(convertedValues);
  }, []);

  let filteredArray;

  if (!isObjectEmpty(selectedValues) && selectedValues != null) {
    filteredArray = filterListItems(selectedValues, listItems);
  } else {
    filteredArray = listItems;
  }

  const uniqueFilteredArray = Array.from(new Set(filteredArray));
  const [currentPage, setCurrentPage] = useState(1);

  useEffect(() => {
    setCurrentPage(1);
    if (!isObjectEmpty(selectedValues) && selectedValues != null) {
      filteredArray = filterListItems(selectedValues, listItems);
    } else {
      filteredArray = listItems;
    }
  }, [selectedValues, listItems]);
 
//console.log("currentPage",currentPage);

  //const itemsPerPage = 6; // Number of items per page
  //const itemsPerPage = restBlockProps?.noOfPageItems ?? 12; // Added by Kripa on 14-2-2024 so that the Number of items per page comes from api and  if not, then 12 is set.

  //const itemsPerPage = restBlockProps?.noOfPageItems ?? noOfItems*3; // Added by Ajith on 21-03-2024 so that the Number of items per page comes from api and  if not, then 12 is set.

  const itemsPerPage = restBlockProps?.noOfPageItems ?? noOfItems*5; // Added by Ajith on 21-03-2024 so that the Number of items per page comes from api and  if not, then 12 is set.
//  const itemsPerPage =12;
  //console.log("noOfPageItems",noOfPageItems);

  const currentItems = uniqueFilteredArray.slice(
    (currentPage - 1) * itemsPerPage,
    currentPage * itemsPerPage
  );


  const pageCount = Math.ceil(uniqueFilteredArray.length / itemsPerPage);

  const handlePageClick = (data) => {
    const selectedPage = data.selected + 1; // Incremented by 1 to match the current page number
    setCurrentPage(selectedPage);
    const newOffset = (selectedPage - 1) * itemsPerPage;
  };

  // Function for setting Active Tab List
  const handleChangeList = useCallback(
    (selectedTabItem) => setActiveTabList(selectedTabItem),
    []
  );

  // Effect for updating the items based on the active
  // Tab List
  useEffect(() => {
    if (activeTabList !== "")
      setListItems(tabList.find((item) => item.key === activeTabList).items);
  }, [activeTabList]);
//console.log("pageCount",pageCount)


const sectionId = scroll_key != "" ? scroll_key : _id;

  return (
    <AppSection explore={!isObjectEmpty(link) ? true : false} id={sectionId}>
      <KtContainer pos="relative" >
        {(heading || description) && (
          <Box pb={5}>
            <SectionHeading heading={heading} description={description} />
          </Box>
        )}

        {/* Rendering Filters for the List */}
        {!isObjectEmpty(filterlist) && (
          <ListFilter
            filters={filterlist}
            search={restBlockProps?.search ?? false}
            handlePrimaryFilterChange={handlePrimaryFilterChange}            
            handlePrimaryFilterClear={handlePrimaryFilterClear}
            selectedValues={selectedValues}
          />
        )}

        {/* Showing Tab List if it's rendered as a tab list component  */}
        {tabList instanceof Array && tabList?.length > 0 && (
          <ListTabs
            tabList={tabList}
            activeTab={activeTabList}
            onClick={handleChangeList}
          />
        )}

        {/* Showing Itinerary Tablist if the filter for is a plan_your_itinerary */}
        {filter_for === "plan_your_itinerary" && (
          <PlanYourItineraryTabList setActiveItinerary={setActiveCategory} />
        )}

        {/* Rendering Category List */}
        {activeCategory === category && (
          <>
            {restBlockProps?.pagination ? (
              <>
                {currentItems.length > 0 ? (
                  <>
                    <CategoryList
                      listItems={currentItems}
                      noOfItems={noOfItems}
                      link={link}
                      category={category}
                      restBlockProps={restBlockProps}
                    />
                  </>
                ) : (
                  <span>No Results found..</span>
                )}
              </>
            ) : (
              <>
                {listItems.length > 0 ? (
                  <CategoryList
                    listItems={listItems}
                    noOfItems={noOfItems}
                    link={link}
                    category={category}
                    restBlockProps={restBlockProps}
                  />
                ) : (
                  <span>No Results found..</span>
                )}
              </>
            )}

            {/* Rendering Pagination Block */}

          
            {pageCount > 1 && restBlockProps?.pagination && (
              <AppPagination
                pageCount={pageCount}
                handlePageClick={handlePageClick}
                currentPage ={currentPage}
              />
            )}
          </>
        )}

        {/* Rendering Ask Query Component */}
        {activeCategory === "query" && <AskQuery />}

        {/* Rendering Ai Suggestion Component */}
        {activeCategory === "ai_suggestion" && (
          <AiSuggestion suggestion={ai_suggestion} />
        )}
      </KtContainer>
    </AppSection>
  );
}

List.propTypes = {
  heading: string,
  description: string,
  image: shape({
    url: string.isRequired,
    alt: string.isRequired,
  }),
  link: shape({
    title: string.isRequired,
    text: string.isRequired,
    type: string.isRequired,
    parent: string.isRequired,
    slug: string,
  }),
};
