import {
  hoverCardYVariant,
  hoverCardYTopToBottomVariant,
} from "@/app/_utils/animationVariants";

export const defaultListImageProps = (
  url,
  alt,
  showType,
  relatedInfo = false
) => ({
  src: url,
  alt,
  ...(showType === "large" && {
    width: 500,
    height: 750,
  }),
  ...(showType === "medium" && {
    width: 500,
    height: 500,
  }),
  ...(showType === "small" && {
    width: 370,
    height: 370,
  }),
  ...(!showType && {
    fill: true,
    sizes: "50vw",
  }),
  style: {
    width: "100%",
    height: "100%",
    borderRadius: "var(--kerala-tourism-radii-md)",
    ...(relatedInfo && {
      borderBottomLeftRadius: "0px",
      borderBottomRightRadius: "0px",
    }),
  },
});

export const defaultListHeadingDescStyles = (showType) => ({
  pos: "absolute",
  w: "full",
  ...(showType === "large" && {
    bottom: 21,
    pt: {
      base: 4,
      md: 30,
    },
    pb: {
      base: 6,
      md: 30,
    },
    pr: {
      base: 4,
      md: 8,
      lg: 50,
    },
    pl: {
      base: 4,
      md: 8,
      lg: 50,
    },
  }),
  ...((showType === "medium" || showType === "small") && {
    bottom: 0,
    p: 5,
  }),
  ...(showType === "small" && {
    maxW: 48,
  }),
  zIndex: 2,
  variants: hoverCardYVariant,
  transition: "0.4s linear",
});

export const monthInfoWrapperStyle = (showType) => ({
  pos: "absolute",
  ...(showType === "large" && {
    top: {
      base: 10,
      md: 0,
    },
    left: 0,
    pt: {
      base: 4,
      md: 30,
    },
    pr: {
      base: 4,
      md: 8,
      lg: 50,
    },
    pl: {
      base: 4,
      md: 8,
      lg: 50,
    },
  }),
  zIndex: 2,
  ...(showType === "medium" && {
    top: 5,
    left: 5,
  }),
  color: "white",
  variants: hoverCardYTopToBottomVariant,
  transition: "0.4s linear",
});
