import { Box, Text } from "@chakra-ui/react";
import { AppTab, AppTabList, AppTabNavItem } from "@/app/_components";
import { useTabStyle } from "@/app/_components/AppTab/hooks";
import { appTextFontSize } from "@/app/_components/_styles";

const planYourItineraryTabList = [
  {
    label: "Packages",
    key: "packages",
  },
  {
    label: "AI Suggestion",
    key: "ai_suggestion",
  },
  {
    label: "Ask your query",
    key: "query",
  },
];

export function ListTabs({ tabList, onClick }) {
  const [tabListRef, tablistStyleProps] = useTabStyle();

  return (
    <Box mb={8}>
      <AppTab align="center">
        <AppTabList
          ref={tabListRef}
          gap={2}
          pr={{
            base: 2,
            md: 0,
          }}
          pb={{
            base: 4,
            "2xl": 10,
          }}
          {...tablistStyleProps}
        >
          {tabList.map(({ label, key }) => (
            <AppTabNavItem
              key={key}
              whiteSpace="nowrap"
              gap={2}
              bg="orangePeel.900"
              color="white"
              shadow="md"
              rounded="full"
              paddingX={8}
              _selected={{
                color: "orangePeel.900",
                bg: "white",
              }}
              transition="all ease-in 0.3s"
              onClick={() => onClick(key)}
            >
              <Text as="span" fontSize={appTextFontSize}>
                {label}
              </Text>
            </AppTabNavItem>
          ))}
        </AppTabList>
      </AppTab>
    </Box>
  );
}

export function PlanYourItineraryTabList({ setActiveItinerary }) {
  const [tabListRef, tablistStyleProps] = useTabStyle();

  return (
    <Box
      maxW={{
        base: "full",
        lg: "lg",
      }}
      mx="auto"
      mb={8}
    >
      <AppTab
        pt={{
          base: 6,
          md: 0,
        }}
        onChange={(index) =>
          setActiveItinerary(planYourItineraryTabList[index].key)
        }
      >
        <AppTabList
          ref={tabListRef}
          gap={{
            md: 4,
            lg: 4,
          }}
          {...tablistStyleProps}
        >
          {planYourItineraryTabList.map(({ label, key }) => (
            <AppTabNavItem
              key={key}
              whiteSpace="nowrap"
              pos="relative"
              fontSize={22}
              _selected={{
                _before: {
                  content: "''",
                  pos: "absolute",
                  bottom: 0,
                  left: 0,
                  h: 0.5,
                  bg: "orangePeel.900",
                  w: "full",
                },
              }}
            >
              {label}
            </AppTabNavItem>
          ))}
        </AppTabList>
      </AppTab>
    </Box>
  );
}
