import { Box, Text, Textarea } from "@chakra-ui/react";
import { BsChevronRight } from "react-icons/bs";
import { AppButton } from "@/app/_components";

export default function AskQuery() {
  return (
    <Box
      p={{
        base: 0,
        md: 0
      }}
      maxW={{
        base: "full",
        lg: "5xl",
      }}
      mx="auto"
    >
      <Text textAlign="center" pb={4}>
        Kerala is divided into three geographical regions: Highlands, which
        slope down from the Western Ghats onto the Midlands of undulating hills
        and valleys into
      </Text>
      <Textarea
        placeholder="Enter your query"
        variant="flushed"
        focusBorderColor="orangePeel.900"
        resize="none"
        rows={5}
      />
      <Box
        maxW="sm"
        mx="auto"
        sx={{
          button: {
            width: "100%",
          },
        }}
        pt={12}
      >
        <AppButton>
          Submit
          <BsChevronRight strokeWidth={1} fontSize="12px" />
        </AppButton>
      </Box>
    </Box>
  );
}
