import { Grid, Box } from "@chakra-ui/react";
import { AppLink } from "@/app/_components";

import { LIST_CATEGORIES } from "@/app/_constants/componentConstant";
import { isObjectEmpty } from "@/app/_utils";

const {
  DEFAULT_LIST,
  INFOCARD_LIST,
  PORTFOLIO_LIST,
  TOURGUIDE_CARD,
  PACKAGE_LIST,
  TRAVEL_TIPS_LIST,
  NEWS_LIST,
  MAJOR_LIST,
} = LIST_CATEGORIES;

import {
  DefaultListItem,
  InfoCardListItem,
  PortfolioListItem,
  TourGuide as TourGuideListItem,
  PackageListItem,
  TravelTipListItem,
  NewsListItem,
  MajorListItem,
} from "../_categories";

export default function CategoryList({
  listItems,
  link,
  noOfItems,
  category,
  restBlockProps,
}) {
  return (
    <Grid
      gridTemplateColumns={{
        base: `repeat(1, 1fr)`,
        md: `repeat(2, 1fr)`,
        lg: "repeat(3, 1fr)",
        xl: `repeat(${noOfItems}, 1fr)`,
      }}
      gap={8}
    >
      {listItems.map(({ _id, ...restProps }) => (
        <Box as="article" key={_id}>
          {(() => {
            switch (category) {
              case DEFAULT_LIST:
                return <DefaultListItem {...restProps} {...restBlockProps} />;
              case INFOCARD_LIST:
                return <InfoCardListItem {...restProps} />;
              case TOURGUIDE_CARD:
                return <TourGuideListItem {...restProps} />;
              case PORTFOLIO_LIST:
                return <PortfolioListItem {...restProps} />;
              case PACKAGE_LIST:
                return <PackageListItem {...restProps} />;
              case TRAVEL_TIPS_LIST:
                return <TravelTipListItem {...restProps} />;
              case NEWS_LIST:
                return <NewsListItem {...restProps} />;
              case MAJOR_LIST:
                return <MajorListItem {...restProps} {...restBlockProps} />;                  
              default:
                return null;
            }
          })()}
        </Box>
      ))}
      {!isObjectEmpty(link) && (
        <Box as="div" pos="absolute" right={4} bottom={-50}>
          <AppLink
            type={link.type}
            parent={link.parent}
            slug={link.slug}
            title={link.title}
            variant="pill"
            color="black"
            arrow
          >
            {link.text}
          </AppLink>
        </Box>
      )}
    </Grid>
  );
}
