import dynamic from "next/dynamic";
import { Box, Flex, Text } from "@chakra-ui/react";

const Rating = dynamic(
  () => import("@/app/_components").then((mod) => mod.Rating),
  { ssr: false }
);

export default function StarRating({ rating }) {
  return (
    <Box pos="absolute" top="10px" left="30px" zIndex={5}>
      <Flex direction="column">
        <Rating rating={rating} starDimension="15px" starSpacing="5px" />
        <Text as="span" color="white">
          {rating} Ratings
        </Text>
      </Flex>
    </Box>
  );
}
