import { Box, Flex, Heading, Text, Avatar } from "@chakra-ui/react";
import { BsDownload } from "react-icons/bs";
import { AppLink } from "@/app/_components";
import { isObjectEmpty } from "@/app/_utils";

export default function RelatedInfo({
  heading,
  sub_heading,
  description,
  download_url,
  author_info = {},
  link: { text, ...restLinkProps },
}) {
  return (
    <Box
      pos="relative"
      p={{
        base: 4,
        md: 8,
      }}
      w="full"
      minH="250px"
    >
      <Flex direction="column" gap={3}>
        {!isObjectEmpty(author_info) && (
          <Flex gap={6} alignItems="center">
            {/* <Avatar src={author_info.avatar_url} size="xl" /> */}
            <Flex direction="column" gap={2}>
              <Text as="h4">
                <Text as="strong">{author_info.author_name}</Text>
              </Text>
              <Text>{author_info.published_at}</Text>
            </Flex>
          </Flex>
        )}
        <AppLink {...restLinkProps}>
        <Heading as="h6" fontSize="30" color="black">
          {heading}
        </Heading>
        </AppLink>
        {sub_heading && (
          <Text as="span" fontWeight="semibold" color="black">
            {sub_heading}
          </Text>
        )}
        {description && <Text as="p">{description}</Text>}
        <Flex gap={5}>
          {download_url && (
            <AppLink
              parent={download_url.parent}
              slug={download_url.slug}
              type={download_url.type}
              title={download_url.title}
              variant="pill"
              color="black"
            >
              {download_url.text}&nbsp;
              <BsDownload />
            </AppLink>
          )}

          <AppLink {...restLinkProps} variant="pill" color="black" arrow>
            {text}
          </AppLink>
        </Flex>
      </Flex>
    </Box>
  );
}
