import { Box, Flex, Text, IconButton } from "@chakra-ui/react";
import { BsFillCircleFill } from "react-icons/bs";

import { KtHeading, AnimationWrapper } from "@/app/_components";

import { months } from "@/app/_utils";
import { appTextFontSize } from "@/app/_components/_styles";

import { monthInfoWrapperStyle } from "../../_styles";

function AdditionalInfo({ date, toDate, type, showType }) {
  return (
    <AnimationWrapper layout {...monthInfoWrapperStyle(showType)}>
     {((date && !toDate) || (date && toDate && new Date(date).toDateString() === new Date(toDate).toDateString())) && (
  <Flex direction="column">
    <KtHeading as="h6" color="#FFF">
      On
    </KtHeading>
    <KtHeading as="h4" color="orangePeel.900">
      {new Date(date).getDate().toString().padStart(2, 0)} {months[new Date(date).getMonth()].toLowerCase()}
    </KtHeading>
    
  </Flex>
)}

{date && toDate && new Date(date).toDateString() !== new Date(toDate).toDateString() && (
  <Flex direction="column">
    <KtHeading as="h6" color="#FFF">
      From
    </KtHeading>
    <KtHeading as="h4" color="orangePeel.900">
      {new Date(date).getDate().toString().padStart(2, 0)} {months[new Date(date).getMonth()].toLowerCase()}
    </KtHeading>
    
  </Flex>
)}
      {type && (
        <Box
          sx={{
            "svg circle": {
              fill:
                type === "veg"
                  ? "var(--kerala-tourism-colors-greenSheen)"
                  : "var(--kerala-tourism-colors-begonia)",
            },
          }}
        >
          <IconButton icon={<BsFillCircleFill />} size="sm" />
        </Box>
      )}
    </AnimationWrapper>
  );
}

export default AdditionalInfo;
