import {
  Box,
  Card,
  Flex,
  IconButton,
  Image,
  Text,
  Tooltip,
} from "@chakra-ui/react";
import { BsEye } from "react-icons/bs";
import { AppLink } from "@/app/_components";

import { isObjectEmpty } from "@/app/_utils";

export default function TravelTipListItem({
  icon_url,
  heading,
  description,
  contact_numbers = [],
  programmes = {},
  website_url = {},
}) {
  return (
    <Card px={4} py={4} h="full" position="relative">
      {!isObjectEmpty(website_url) && (
        <Box pos="absolute" right={4} top={4}>
          <AppLink
            title={website_url.title}
            parent={website_url.parent}
            slug={website_url.slug}
            type={website_url.type}
            _hover={{
              "svg fill": {
                color: "white",
              },
            }}
          >
            <Tooltip
              hasArrow
              label={website_url.text}
              placement="left"
              bg="orangePeel.900"
              color="white"
            >
              <IconButton
                aria-label={website_url.text}
                bg="sage.900"
                _hover={{
                  bg: "orangePeel.900",
                }}
                icon={<BsEye color="white" />}
                isRound
              />
            </Tooltip>
          </AppLink>
        </Box>
      )}
      <Flex direction="column" gap={4} pt={6} pb={6}>
        <Image src={icon_url} width={45} h={45} alt={heading} />
        <Text as="h5" fontSize="26" fontWeight="semibold">
          {heading}
        </Text>
        {description && <Text style={{ whiteSpace: 'pre-wrap' }}>{description}</Text>}
        {!isObjectEmpty(programmes) && <Text>Programmes</Text>}
        {contact_numbers.length > 0 && (
          <Flex direction="column">
            {contact_numbers.map(({ _id, label, numbers }) => (
              <Text key={_id}>
                {label} : {numbers.join(",")}
              </Text>
            ))}
          </Flex>
        )}
      </Flex>
    </Card>
  );
}
