import dynamic from "next/dynamic";
import { number, shape, string } from "prop-types";
import {
  Box,
  Card,
  CardBody,
  Flex,
  Avatar,
  Text,
  IconButton,
} from "@chakra-ui/react";
import { BsTelephone } from "react-icons/bs";
import { AppLink, AppImage, AppBox } from "@/app/_components";
import Link from "next/link";

const Rating = dynamic(
  () => import("@/app/_components").then((mod) => mod.Rating),
  { ssr: false }
);

export default function TourGuide({
  image: { url, alt, base64 },
  guide_info: { image, name, agency, contact_num, rating },
  link: { text, parent, title, type, ...restLinkProps },
}) {
  if(type==="internal") type="_self"; else type="_blank";
  const cardContent = (
    <Card>
      <AppImage
        src={url}
        alt={alt}
        height={317}
        width={517}
        blurDataURL={base64}
        style={{ width: "100%" }}
      />
      <CardBody p={5}>
      {name &&
        <Flex justify="space-between">
          <Rating rating={rating} />
          <Box as="div">
            <IconButton
              onClick={() => document.location.href = `tel:${contact_num}`}
              aria-label={`Contact ${name}`}
              size="lg"
              icon={<BsTelephone />}
            />
          </Box>
        </Flex>}
        {name &&
        <Flex py={5} align="center" gap={5}>
          <Avatar src={image} size="xl" />
          <Box as="div">
            <Text as="p" fontWeight="bold">
              {name}
            </Text>
            <Text as="span">{agency}</Text>
          </Box>
        </Flex>
        }
        {text &&
        <Box pb={3}>
          <AppBox variant="pill" color="white" {...restLinkProps} arrow>
            {text}
          </AppBox>
        </Box>
        }
      </CardBody>
    </Card>
  );

  return parent ? (
    <Link href={parent} target={type} {...restLinkProps}>
      {cardContent}
    </Link>
  ) : (
    cardContent
  );
}

TourGuide.propTypes = {
  image: shape({
    url: string.isRequired,
    alt: string.isRequired,
    base64: string.isRequired,
  }).isRequired,
  guide_info: shape({
    image: string.isRequired,
    name: string.isRequired,
    agency: string.isRequired,
    contact_num: string.isRequired,
    rating: number.isRequired,
  }).isRequired,
  link: shape({
    title: string.isRequired,
    text: string.isRequired,
    type: string.isRequired,
    parent: string.isRequired,
    slug: string,
  }).isRequired,
};
