import { Card, Box, Flex, Text, Image } from "@chakra-ui/react";
import { AppLink, KtHeading } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import Link from "next/link";
export default function PortfolioListItem({
  heading,
  description,
  image: { url, alt },
  link,
}) {
  let prnt; let trg; let ur;

  if(link){
    link.type === "internal" || link.type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + link.parent 
        : link.type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + link.parent 
        : prnt=link.parent 
      ur = (prnt ?? "").concat(link.slug ?? "");
    
      link.type!='internal-other' &&  link.type!='external' ? trg="" : trg="_blank";
  }  
  return (
    <Card borderRadius="lg">
      <Flex
        p={5}
        display="flex"
        justifyContent="center"
        bg="antiFlashWhite"
        borderTopRightRadius="lg"
        borderTopLeftRadius="lg"
      ><Link href={ur} title={heading} target={trg} >
        <Image src={url} alt={alt} title={alt}  width={150} height={110} />
        </Link>
      </Flex>
      <Flex
        direction="column"
        p={5}
        gap={{
          base: 2,
          md: 5,
        }}
      >
        <KtHeading as="h6" color="black">
        <Link href={ur} title={heading} target={trg} >
          {heading}
         </Link> 
        </KtHeading>
        <Text as="p" fontSize={appTextFontSize}>
          {description}
        </Text>
        <Box display="inline-flex">
          <AppLink title={link.title}
                  parent={link.parent}
                  slug={link.slug}
                  type={link.type}
                  variant="pill"
                  color="black" arrow>
            {link.text}
          </AppLink>
        </Box>
      </Flex>
    </Card>
  );
}
