import { Box, Card, Flex, Text } from "@chakra-ui/react";
import { format } from "date-fns";
import { AppLink } from "@/app/_components";

const PackageRate = ({ type, package_rate }) => {
  const { from, to } = package_rate[type];

  if (type === "inr")
    return (
      <Text as="span">
        &#8377;{from} - &#8377;{to}
      </Text>
    );
  else
    return (
      <Text as="span">
        &#36;{from} - &#36;{to}
      </Text>
    );
};

export default function PackageListItem({
  package_name,
  experience,
  location,
  total_nights,
  total_days,
  package_rate,
  offer_valid_till,
  link: { text, ...restLinkProps },
}) {
  return (
    <Card px={4} py={4} borderRadius="lg">
      <Flex direction="column" gap={2}>
        <Text fontSize="24" fontWeight="semibold">
          {package_name}
        </Text>
        <Text color="orangePeel.900" fontSize="20" fontWeight="medium">
          {experience} <br /> Experience
        </Text>
        <Text fontSize="18" fontWeight="light" color="#4D4D4D">
          {location}
        </Text>
        <Text fontSize="18" color="#707070">
          {total_nights} Nights / {total_days} Days
        </Text>
        {package_rate && offer_valid_till && (
          <Text fontSize="18" color="#707070" fontWeight="medium">
            <PackageRate type="inr" package_rate={package_rate} /> ,{" "}
            <PackageRate type="dollar" package_rate={package_rate} /> <br />
            <Text as="span">
              Valid upto {format(new Date(offer_valid_till), "dd-MM-yyyy")}
            </Text>
          </Text>
        )}

        <Box display="inline-flex" pt={4} pb={4}>
          <AppLink {...restLinkProps} color="black" variant="pill" arrow>
            {text}
          </AppLink>
        </Box>
      </Flex>
    </Card>
  );
}
