import { Box, Text, Flex, IconButton } from "@chakra-ui/react";

import {
  AppLink,
  AppBox,
  KtHeading,
  AppImage,
  AnimationWrapper,
} from "@/app/_components";

import { isObjectEmpty } from "@/app/_utils";
import { appTextFontSize } from "@/app/_components/_styles";
import { scaleVariant } from "@/app/_utils/animationVariants";

import {
  defaultListImageProps,
  defaultListHeadingDescStyles,
} from "../_styles";

import Link from "next/link";


export default function MajorListItem({
  heading,
  description,
  image: { url, alt, base64 },
  link,
  showType,
  
  related_info = {},
  
}) {

  

  let prnt; let trg; let ur;

  if(link){
    link.type === "internal" || link.type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + link.parent 
        : link.type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + link.parent 
        : prnt=link.parent 
      ur = (prnt ?? "").concat(link.slug ?? "");
    
      link.type!='internal-other' &&  link.type!='external' ? trg="" : trg="_blank";
  }
  else if(!isObjectEmpty(related_info)){
    related_info.link.type === "internal" || related_info.link.type === "link"
    ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + related_info.link.parent 
    : related_info.link.type === "internal-other"
    ? prnt=process.env.NEXT_PUBLIC_OLD_URL + related_info.link.parent 
    : prnt=related_info.link.parent 
    ur = (prnt ?? "").concat(related_info.link.slug ?? "");

    related_info.link.type!='internal-other' &&  related_info.link.type!='external' ? trg="" : trg="_blank";
  }
  else{
    ur='#';
    trg='';
  }  
  return (
    <Link href={ur} title={heading} target={trg} >
    <Box
      pos="relative"
      bg="antiFlashWhite"
      borderRadius="2%"
      {...(!isObjectEmpty(related_info) && {
        borderBottomLeftRadius: "0px",
        borderBottomRightRadius: "0px",
      })}
      height="full"
    >
      <AnimationWrapper
        {...(!isObjectEmpty(related_info) && {
          borderBottomLeftRadius: "0px",
          borderBottomRightRadius: "0px",
        })}
        borderRadius="2%"
        whileHover
        animateRoot
      >
        {/* Rendering Root Image for the List */}
        
        <AnimationWrapper layout overflow={false}>
          <AnimationWrapper
            variants={scaleVariant}
            transition="0.5s linear"
            overlayType="light"
            overlay
            overflow={false}
            transformTemplate={(props, transform) =>
              transform.replace(" translateZ(0)", "")
            }
          >
            <AppImage
              {...defaultListImageProps(
                url,
                alt,
                showType,
                !isObjectEmpty(related_info)
              )}
              blurDataURL={base64}
            />
            
          </AnimationWrapper>
        </AnimationWrapper>
         
        

<Box pos="absolute" bottom={0} p={5} color="white" zIndex={2}>
        <Flex gap={4} direction="column">
          <KtHeading as="h4" color="white">
          
            {heading}
            
          </KtHeading>
          <Text as="p" fontSize={appTextFontSize}>
            {description}
          </Text>
                   
        </Flex>
      </Box>

        
      </AnimationWrapper>


    </Box>
    </Link>     
  );
}
