import dynamic from "next/dynamic";

import { BsHeart, BsHeartFill } from "react-icons/bs";
import { Box, Text, IconButton } from "@chakra-ui/react";
import {
  AppLink,
  AppBox,
  KtHeading,
  AppImage,
  AnimationWrapper,
} from "@/app/_components";

import { isObjectEmpty } from "@/app/_utils";
import { appTextFontSize } from "@/app/_components/_styles";
import { scaleVariant } from "@/app/_utils/animationVariants";

import {
  defaultListImageProps,
  defaultListHeadingDescStyles,
} from "../_styles";
import Link from "next/link";


const AdditionalInfo = dynamic(() => import("./_components/AdditionalInfo"));
const RelatedInfo = dynamic(() => import("./_components/RelatedInfo"));
const StarRating = dynamic(() => import("./_components/StarRating"));

export default function DefaultListItem({
  heading,
  description,
  image: { url, alt, base64 },
  link,
  showType,
  rating,
  fav = false,
  fromDate = "",
  toDate = "",
  type = "",
  related_info = {},
  isFavAdded = false,
  category=""
}) {


  let prnt; let trg; let ur;

  if(link){
    link.type === "internal" || link.type === "link"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + link.parent 
        : link.type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + link.parent 
        : prnt=link.parent 
      ur = (prnt ?? "").concat(link.slug ?? "");
    
      link.type!='internal-other' &&  link.type!='external' ? trg="" : trg="_blank";
  }
  else if(!isObjectEmpty(related_info)){
    related_info.link.type === "internal" || related_info.link.type === "link"
    ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + related_info.link.parent 
    : related_info.link.type === "internal-other"
    ? prnt=process.env.NEXT_PUBLIC_OLD_URL + related_info.link.parent 
    : prnt=related_info.link.parent 
    ur = (prnt ?? "").concat(related_info.link.slug ?? "");

    related_info.link.type!='internal-other' &&  related_info.link.type!='external' ? trg="" : trg="_blank";
  }
  else{
    ur='#';
    trg='';
  }
  
  return (
   
    <Box
      pos="relative"
      bg="antiFlashWhite"
      borderRadius="2%"
      {...(!isObjectEmpty(related_info) && {
        borderBottomLeftRadius: "0px",
        borderBottomRightRadius: "0px",
      })}
      height="full"
     
    >
    
      
        <AnimationWrapper
      cursor="pointer"
          {...(!isObjectEmpty(related_info) && {
            borderBottomLeftRadius: "0px",
            borderBottomRightRadius: "0px",
          })}
          borderRadius="2%"
          whileHover
          animateRoot
        >
          {/* Rendering Root Image for the List */}
          <Link href={ur} title={heading} target={trg} >
          <AnimationWrapper layout overflow={false}>
            <AnimationWrapper
            
              variants={scaleVariant}
              transition="0.5s linear"
              overlayType="light"
              overlay
              overflow={false}
              transformTemplate={(props, transform) =>
                transform.replace(" translateZ(0)", "")
              }
            >
              <AppImage title={alt} 
                {...defaultListImageProps(
                  url,
                  alt,
                  showType,
                  !isObjectEmpty(related_info)
                )}
                blurDataURL={base64}
                
              />
              
            </AnimationWrapper>
          </AnimationWrapper>
          </Link>      
          {/*  Rendering Fav Icon */}
          {fav && (
            <Box pos="absolute" top={5} right={5} zIndex={2}>
              <IconButton
                fontSize="25px"
                color="white"
                _hover={{
                  bg: "blackAlpha.300",
                }}
                bg="blackAlpha.500"
                size="lg"
                onClick={(e) => e.preventDefault()}
                icon={
                  !isFavAdded ? (
                    <BsHeart />
                  ) : (
                    <BsHeartFill fill="var(--kerala-tourism-colors-orangePeel-900)" />
                  )
                }
                isRound
              />
            </Box>
          )}

          {/* Renering Heading | Description | Link */}
          {(heading || description || link) && (
            <Link href={ur} title={heading} target={trg} >
            <AnimationWrapper
              layout
              {...defaultListHeadingDescStyles(showType)}
              overflow={false}
            >
              {heading && (
                <KtHeading as="h6" color="white" pb={2}>
                  
                  {heading.length > 60
                    ? heading.substr(0, 60).concat("...")
                    : heading}
                   
                </KtHeading>
              )}

              
            </AnimationWrapper>
            </Link> 
          )}
          {/* Rendering Event Dates Or Food Type Square */}
          {(fromDate || type) && (
            <Link href={ur} title={heading} target={trg} >
            <AdditionalInfo date={fromDate} toDate={toDate} showType={showType} type={type} /> 
            </Link>
          )}
          {/* Rendering Star Rating */}
          {rating && <Link href={ur} title={heading} target={trg} ><StarRating rating={rating} /> </Link>}
        </AnimationWrapper>        
      
      {/* Rendering Default List Related information */}
      {!isObjectEmpty(related_info) && <Link href={ur} title={heading} target={trg} ><RelatedInfo {...related_info} /></Link>}
    </Box>
  );
}
