import { LIST_CATEGORIES } from "@/app/_constants/componentConstant";

import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";

import List from ".";

const { INFOCARD_LIST, PACKAGE_LIST, TRAVEL_TIPS_LIST, NEWS_LIST, MAJOR_LIST } =
  LIST_CATEGORIES;

export async function ListLoader(props) {
  const {
    block: { category },
  } = props;

  let reducedResults = props;

  if (
    ![INFOCARD_LIST, PACKAGE_LIST, TRAVEL_TIPS_LIST, NEWS_LIST, MAJOR_LIST].some(
      (c) => c === category
    )
  ) {
    if (reducedResults.hasOwnProperty("tabList")) {
      const tabList = reducedResults.tabList;
      const tabListKeys = new Map();

      for (const list of tabList) {
        tabListKeys.set(list.key, list.items);
      }

      for (let i = 0; i < tabList.length; i++) {
        const items = tabListKeys.get(tabList[i]["key"]);
        await Promise.all(items.map(async (item) => {
          const { url } = item.image;
          const base64ImageUrl = await getBase64ImageUrl(url);
          return {
            ...item,
            image: {
              ...item.image,
              base64: base64ImageUrl,
            },
          };
        })).then((result) => {
          tabListKeys.set(tabList[i]["key"], result);
        });
      }

      for (let i = 0; i < tabList.length; i++) {
        tabList[i]["items"] = [
          ...tabListKeys.get(tabList[i]["key"]),
        ];
      }

      reducedResults = {
        ...reducedResults,
        tabList,
      };
    } else {
      const items = props.items;
      const blurImagePromise = items.map(({ image: { url } }) =>
        getBase64ImageUrl(url)
      );

      const imageWithBlurDataUrls = await Promise.all(blurImagePromise);

      for (let i = 0; i < items.length; i++) {
        items[i].image = {
          ...items[i].image,
          base64: imageWithBlurDataUrls[i],
        };
      }

      reducedResults = {
        ...reducedResults,
        items,
      };
    }
  }

  return <List {...reducedResults} />;
}
