"use client";

import { Grid, Box, Flex } from "@chakra-ui/react";
import { KtContainer, AppSection, AppImage } from "@/app/_components";

import DefaultCard from "./_components/DeaultCard";
import ContactCard from "./_components/ContactCard";

export default function HighlightCard({
  block,
  image: { url, alt, base64 },
  ...restProps
}) {
  const { category } = block;

  const imageStyle = { width: "100%", height: "100%" };
  const hightLightCardImageProps =
    category === "default"
      ? { width: 800, height: 800, style: imageStyle }
      : { width: 800, height: 450, style: imageStyle };

  return (
    <AppSection>
      <KtContainer>
        <Grid
          templateColumns={{
            md: "repeat(1, 1fr)",
            lg: "repeat(2, 1fr)",
          }}
          pt={6}
          pb={6}
        >
          <AppImage
            src={url}
            blurDataURL={base64}
            alt={alt}
            {...hightLightCardImageProps}
          />
          <Box
            p={{
              base: 4,
              lg: 10,
            }}
            bg="#EFF3F7"
          >
            <Flex direction="column" gap={3} h="full" justify="center">
              {category === "default" ? (
                <DefaultCard {...restProps} />
              ) : (
                <ContactCard {...restProps} />
              )}
            </Flex>
          </Box>
        </Grid>
      </KtContainer>
    </AppSection>
  );
}
