import { Heading, Text, Flex } from "@chakra-ui/react";
import { BsDownload } from "react-icons/bs";
import { AppMarkDown, AppLink } from "@/app/_components";
import { isObjectEmpty } from "@/app/_utils";

export default function DefaultCard({
  heading,
  sub_heading,
  content,
  link = {},
  download_url = {},
}) {
  return (
    <>
      <Heading as="h6" fontSize="30" color="black">
        {heading}
      </Heading>
      {sub_heading && (
        <Text as="span" fontWeight="semibold" color="black">
          {sub_heading}
        </Text>
      )}
      {content && <AppMarkDown content={content} />}
      {(!isObjectEmpty(link) || !isObjectEmpty(download_url)) && (
        <Flex gap={5}>
          {!isObjectEmpty(download_url) && (
            <AppLink
              parent={download_url.parent}
              slug={download_url.slug}
              type={download_url.type}
              title={download_url.title}
              variant="pill"
              color="black"
            >
              {download_url.text}&nbsp;
              <BsDownload />
            </AppLink>
          )}
          {!isObjectEmpty(link) && (
            <AppLink
              type={link.type}
              title={link.title}
              parent={link.parent}
              slug={link.slug}
              variant="pill"
              color="black"
              arrow
            >
              {link.text}
            </AppLink>
          )}
        </Flex>
      )}
    </>
  );
}
