import { Box, Flex, Text, Image } from "@chakra-ui/react";
import { AppLocationButton } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";

export default function ContactCard({
  address,
  contact_no,
  mail,
  fax,
  tollfree_no,
  location_url,
}) {
  return (
    <>
      <Text fontSize={appTextFontSize}>{address}</Text>
      <Flex gap={6} alignItems="center">
        <Image w={30} h={30} alt="contact" src="/icons/contact.svg" />
        <Text fontSize={appTextFontSize}>{contact_no}</Text>
      </Flex>
      <Flex gap={6} alignItems="center">
        <Image w={30} h={30} alt="contact" src="/icons/mail.svg" />
        <Text fontSize={appTextFontSize}>{mail}</Text>
      </Flex>
      <Flex gap={6} alignItems="center">
        <Image w={30} h={30} alt="contact" src="/icons/fax.svg" />
        <Text fontSize={appTextFontSize}>{fax}</Text>
      </Flex>
      <Flex gap={6} alignItems="center">
        <Image w={30} h={30} alt="contact" src="/icons/tollfree.svg" />
        <Text fontSize={appTextFontSize}>
          {tollfree_no}{" "}
          <Text as="span" fontSize="16">
            (within india only)
          </Text>
        </Text>
      </Flex>
      <Box display="inline-flex" pt={6}>
        <AppLocationButton location_url={location_url} />
      </Box>
    </>
  );
}
