import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";
import HighLightCard from ".";

export async function HighLightCardLoader(props) {
  let reducedResults = props;
  const {
    image: { url },
  } = reducedResults;

  await getBase64ImageUrl(url).then((result) => {
    reducedResults = {
      ...reducedResults,
      image: {
        ...reducedResults.image,
        base64: result,
      },
    };
  });

  return <HighLightCard {...reducedResults} />;
}
