"use client";

import { Box, Text } from "@chakra-ui/react";
import {
  KtContainer,
  SectionHeading,
  AppSection,
  KtHeading,
  AppImage,
  AppLink,
} from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";

export default function HighlightBgStory({
  heading,
  description,
  item: {
    heading: storyHeading,
    image: { url, alt, base64 },
    description: storyDescription,
    link: { text, ...restLinkProps },
  },
}) {
  return (
    <AppSection>
      {(heading || description) && (
        <KtContainer maxW="container.xl">
          <SectionHeading heading={heading} description={description} />
        </KtContainer>
      )}
      <Box
        pos="relative"
        clipPath="inset(0 0 0 0)"
        _before={{
          content: "''",
          backgroundColor: "blackAlpha.500",
          pos: "absolute",
          w: "full",
          h: "full",
          top: 0,
          left: 0,
          zIndex: 1,
        }}
      >
        <Box pos="fixed" left={0} top={0} h="full" w="full">
          <AppImage
            src={url}
            alt={alt}
            title={alt}
            blurDataURL={base64}
            fill
            sizes="100vw"
            style={{ objectFit: "cover", width: "100%" }}
          />
        </Box>
        <KtContainer
          maxW="container.md"
          zIndex={2}
          pos="relative"
          py={{
            base: 12,
            md: "20",
            lg: "60",
          }}
        >
          <Box as="div" textAlign="center">
            <KtHeading as="h4" color="white" mb="0" pb={2}>
              {storyHeading}
            </KtHeading>
            <Text as="p" color="white" pb={4} fontSize={appTextFontSize}>
              {storyDescription}
            </Text>
            <AppLink variant="pill" arrow {...restLinkProps}>
              {text}
            </AppLink>
          </Box>
        </KtContainer>
      </Box>
    </AppSection>
  );
}
