"use client";

import Image from "next/image";
import { motion } from "framer-motion";

import { Box, Flex, Text, useMediaQuery } from "@chakra-ui/react";

import {
  AppSection,
  KtHeading,
  AppLink,
  KtContainer,
} from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import { isObjectEmpty } from "@/app/_utils";
import Link from "next/link";

//const ImageItem = ({ flow = "normal", image: { url, alt, base64 }, isSmallDevice , link: { parent="", slug="", type="" }}) => {

const ImageItem = ({ flow = "normal", image: { url, alt, base64 }, isSmallDevice, link }) => {
    const { parent = "", slug = "", type = "" } = link || {};

  const imageType = url.split(".")[1];
  const borderRadius = {
    ...(flow === "normal" &&
      !isSmallDevice && {
        borderTopRightRadius: "var(--kerala-tourism-radii-md)",
        borderBottomRightRadius: "var(--kerala-tourism-radii-md)",
      }),
    ...(flow === "reverse" &&
      !isSmallDevice && {
        borderTopLeftRadius: "var(--kerala-tourism-radii-md)",
        borderBottomLeftRadius: "var(--kerala-tourism-radii-md)",
      }),
    ...(isSmallDevice && {
      borderTopLeftRadius: "var(--kerala-tourism-radii-md)",
      borderTopRightRadius: "var(--kerala-tourism-radii-md)",
    }),
  };
  let linkUrl ='';
  let prnt;
  let target;
  if(link){
   
    type === "internal"
        ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
        : type === "internal-other"
        ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
        : prnt=parent 
     linkUrl = (prnt ?? "").concat(slug ?? "");

    if (type !== "internal") {
      target = 'target="_blank" rel="noopener noreferrer"';
    }
  }
  return (
    <Box
      order={{
        base: 1,
        md: flow === "normal" ? 1 : 2,
      }}
      w={{
        base: "full",
        md: "calc(50% + 100px)",
      }}
      as={motion.div}
      {...borderRadius}
      {...(imageType !== "svg" && {
        whileHover: "hover",
      })}
      initial={false}
      overflow="hidden"
    >
      <Box
        as={motion.figure}
        variants={{
          hover: {
            scale: 1.1,
          },
        }}
        transition="0.8s linear"
        pos="relative"
      >
       {linkUrl ? (
        <Link 
        href={linkUrl} 
        {...(type !== "internal" && { ...{ target } })}
        >
        <Image
          src={url}
          alt={alt}
          title={alt}
          width={1024}
          height={576}
          sizes="100vw"
          style={{
            width: "100%",
            height: "auto",
            ...borderRadius,
          }}

          {...(imageType !== "svg" && {
            placeholder: "blur",
            blurDataURL: base64,
          })}
        /></Link>
      ) : (
        <Image
          src={url}
          alt={alt}
          title={alt}
          width={1024}
          height={576}
          sizes="100vw"
          style={{
            width: "100%",
            height: "auto",
            ...borderRadius,
          }}

          {...(imageType !== "svg" && {
            placeholder: "blur",
            blurDataURL: base64,
          })}
        />
      )}
      </Box>
    </Box>
  );
};

const IntroItem = ({ flow = "normal", heading, description, link = {} }) => {
  return (
    <Flex
      direction="column"
      justify="center"
      h="full"
      w={{
        base: "full",
        md: "500px",
      }}
      gap={{
        base: 4,
        md: 6,
      }}
      {...(isObjectEmpty(link) && {
        pb: {
          base: 6,
          md: 0,
        },
      })}
      px={{
        base: 6,
        md: 10,
      }}
      order={{
        base: 2,
        md: flow === "normal" ? 2 : 1,
      }}
      bg={{
        base: "#F9FAFC",
        md: "white",
      }}
    >
      <KtHeading
        as="h4"
        color="black"
        pt={{
          base: 4,
          md: 0,
        }}
      >
        {heading}
      </KtHeading>
      <Text as="p" color="black" fontSize={appTextFontSize}>
        {description}
      </Text>
      {!isObjectEmpty(link) && (
        <Box
          display="inline-flex"
          pb={{
            base: 6,
            md: 0,
          }}
        >
          <AppLink
            variant="pill"
            type={link.type}
            title={link.title}
            parent={link.parent}
            slug={link.slug}
            color="black"
            arrow
          >
            {link.text}
          </AppLink>
        </Box>
      )}
    </Flex>
  );
};

export default function Grid({
  sequence,
  heading,
  description,
  image,
  link,
  block: { fullWidth = true },
  ...restProps
}) {
  const sectionId = restProps?.scroll_key ?? restProps._id;
  const [isSmallDevice] = useMediaQuery("(max-width: 767px)");

  const flow = sequence % 2 === 0 ? "reverse" : "normal";
  const GridWrapper = fullWidth && !isSmallDevice ? Box : KtContainer;

  const _flexRootStyle = {
    align: "center",
    ...(flow === "reverse" && {
      justify: "flex-end",
    }),
    ...(!fullWidth && {
      gap: 20,
    }),
  };

  return (
    <AppSection id={sectionId}>
      <GridWrapper>
        <Flex
          {..._flexRootStyle}
          direction={{
            base: "column",
            md: "row",
          }}
        >
          
          <ImageItem flow={flow} image={image} isSmallDevice={isSmallDevice} link={link} />
          <IntroItem
            flow={flow}
            heading={heading}
            description={description}
            link={link}
          />
        </Flex>
      </GridWrapper>
    </AppSection>
  );
}
