const masnoryFullRowSpan = {
  base: 7,
  sm: 11,
  md: 12,
  lg: 10,
  xl: 12,
};

const masnoryHalfRowSpan = {
  base: 8,
  sm: 12,
  md: 15,
  lg: 12,
  xl: 14,
};

export const masnoryRowGridItemProps = {
  "odd-row": {
    1: {
      colStart: {
        base: 1,
      },
      colEnd: {
        base: 13,
        lg: 7,
      },
      rowSpan: { ...masnoryFullRowSpan },
    },
    2: {
      colStart: {
        base: 1,
        lg: 7,
      },
      colEnd: {
        base: 7,
        lg: 10,
      },
      rowSpan: {
        ...masnoryHalfRowSpan,
      },
    },
    3: {
      colStart: {
        base: 7,
        lg: 10,
      },
      colEnd: {
        base: 13,
        lg: 13,
      },
      rowSpan: {
        ...masnoryHalfRowSpan,
      },
    },
  },
  "even-row": {
    1: {
      colStart: {
        base: 1,
        lg: 1,
      },
      colEnd: {
        base: 7,
        lg: 4,
      },
      rowSpan: {
        ...masnoryHalfRowSpan,
      },
    },
    2: {
      colStart: {
        base: 7,
        lg: 4,
      },
      colEnd: {
        base: 13,
        lg: 7,
      },
      rowSpan: {
        ...masnoryHalfRowSpan,
      },
    },
    3: {
      colStart: {
        base: 1,
        lg: 7,
      },
      colEnd: {
        base: 13,
        lg: 13,
      },
      rowSpan: { ...masnoryFullRowSpan },
    },
  },
};
