"use client";

import { Box, Grid, GridItem } from "@chakra-ui/react";
import {
  KtContainer,
  AppLink,
  AppBox,
  AppImage,
  AnimationWrapper,
  AppSection,
  KtHeading,
} from "@/app/_components";
import Link from "next/link";
import {
  scaleVariant,
  hoverCardYVariant,
} from "@/app/_utils/animationVariants";

import { masnoryRowGridItemProps } from "./styles";

const MasnoryGrid = ({ rowSequence, items }) => {
  const rowType = rowSequence % 2 === 0 ? "even-row" : "odd-row";
  const gridRowStyleProps = masnoryRowGridItemProps[rowType];

  return (
    <>
      {items.map(
        (
          { _id, title, image: { url, alt, base64 }, link: { text,type,parent,slug, ...restLinkProps } },
          idx
        ) =>{
        let prnt;
      type === "internal" || type === "link"
            ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
            : type === "internal-other"
            ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
            : prnt=parent 
        const ur = (prnt ?? "").concat(slug ?? "");
        let trg;
        type!='internal-other' &&  type!='external' ? trg="" : trg="_blank";
        
        return (
          
          <GridItem
            key={_id}
            pos="relative"
            display="inline-grid"
            {...gridRowStyleProps[idx + 1]}
          >
            <Link href={ur} title={title} target={trg} >
            <AnimationWrapper
              animateRoot
              whileHover
              h="full"
              borderRadius="10px"
            >
              <AnimationWrapper
                variants={scaleVariant}
                transition="0.8s ease-out"
                overlayType="light"
                position="relative"
                h="full"
                layout
                overlay
              >
                <AppImage
                  sizes="50vw"
                  src={url}
                  alt={alt}
                  title={alt}
                  blurDataURL={base64}
                  style={{
                    width: "100%",
                    height: "100%",
                    borderRadius: "10px",
                    objectFit: "cover",
                  }}
                  fill
                />
                
              </AnimationWrapper>
              <AnimationWrapper
                pos="absolute"
                w="full"
                zIndex={2}
                py={{
                  base: 6,
                  md: 12,
                }}
                px={{
                  base: 6,
                  md: 8,
                }}
                bottom={0}
                transition="0.4s ease-out"
                variants={hoverCardYVariant}
                layout
              >
                <KtHeading
                  as="h5"
                  color="white"
                  mb={{
                    base: 4,
                  }}
                >
                  {title} 
                </KtHeading>
                <Box>
                  <AppBox title={title}   type={type}  parent={parent}  slug = {slug}  {...restLinkProps} variant="pill" arrow>
                    {text}
                  </AppBox>
                </Box>
              </AnimationWrapper>
            </AnimationWrapper>
            </Link>
          </GridItem>
        );
      })}
    </>
  );
};



export default function GalleryGrid({ _id, items, scroll_key = "" }) {
  const sectionId = scroll_key != "" ? scroll_key : _id;

  return (
    <AppSection id={sectionId}>
      <KtContainer>
        <Grid
          templateColumns="repeat(12, 1fr)"
          gridAutoRows="25px"
          gap={{ base: 1, md: 4, lg: 4 }}
        >
          {items.map(({ _id, items }, idx) => (
            <MasnoryGrid key={_id} rowSequence={idx + 1} items={items} />
          ))}
        </Grid>
      </KtContainer>
    </AppSection>
  );
}
